package ${package};

import java.util.Iterator;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import java.io.FileWriter;
import java.io.IOException;
import costo.kml2java.framework.test.ServiceEvolutionValidator;

<#list imports?if_exists as import>
import ${import};
</#list>

public class ${name}{
	static Document doc;
	static Element racine;
	static SAXBuilder sxb;
    static List<Element> tcases;		        
	static String dataFilePath = "${xml_path}";
	
	public ${name}() {
		
	}
	
	public static List<Element> initLauncher(){
		try {
			sxb = new SAXBuilder();
			doc = sxb.build(dataFilePath);
			racine = doc.getRootElement();
	        tcases = racine.getChildren("testcase");			        
		} catch (JDOMException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return tcases;
	}
	public static void main(String [] args){
		List<Element> list = ${name}.initLauncher();
	    Iterator<Element> l = list.iterator();
        while(l.hasNext()){		
		    ${package_lib}.${class_lib}.currentNode = (Element) l.next();
			${component_class_name} comp = new ${component_class_name}("run",null,"");
			comp.addServiceListener(new ServiceEvolutionValidator());
			comp.init();
			try {
				/**
				 *  Delais minimum necessaire pour laisser chaque trade arriver jusqu'au verdict : 500 sec
				 *  Delais de securit 1000
				 */
				Thread.sleep(800);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
       }
		XMLOutputter xmlOutput = new XMLOutputter();
		xmlOutput.setFormat(Format.getPrettyFormat());
		dataFilePath = dataFilePath.replace(".xml", "_res.xml");
		try {
			xmlOutput.output(doc, new FileWriter(dataFilePath));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("File updated!");
		System.exit(0);
	}
}