<#assign dt = today>
<#assign lctx = latexContext>
\NeedsTeXFormat{LaTeX2e}
%generated by the KMLtoTEX export utilities
%author : COLOSS
%date: ${dt?date} Current time: ${dt?time}
%\batchmode
\usepackage[dvips]{epsfig}
\usepackage[T1]{fontenc}
\usepackage{ae}
\usepackage{graphicx}
%\usepackage{amsmath}
\usepackage{amssymb}
\usepackage{xspace} 
\usepackage[savemem]{listings}

%-------- LaTeX style for Kmelia specifications
\def\servc{!\! \!!}
\def\servr{?\! \!?}
\newcommand{\lopt}{$\ldata$}
\newcommand{\ropt}{$\rdata$}
\newcommand{\lman}{$\lbag$}
\newcommand{\rman}{$\rbag$}   %\texttt{<\!< >\!>}
\newcommand{\lropt}{\lopt\ropt} %\verb/<< >>/
\newcommand{\lrman}{\lman\rman} %\verb/[[ ]]/
% pas ok avec la forme ascii
\renewcommand{\lrman}{\verb/[[ ]]/}
% les noms en plus clair ... manadatory Service hook...
\newcommand{\mandatShook}{\verb/[[ ]]/}
\newcommand{\optionShook}{$\ldata~\rdata$}
\newcommand{\etc}{\dots}

%-------- TODO Set a Kml listing configuration
\newcommand{\repLATEX}{${lctx.latexdir}}
\newcommand{\repSTYLES}{\repLATEX/STYLES}
\usepackage{\repSTYLES/Kmelia}
\newcommand{\K}[1]{\lstinline[language=Kmelia,basicstyle={\sffamily}]{#1}} 
\newcommand{\kmelia}{\textsf{Kmelia}\xspace}
%\newcommand{\specKmelia}[3] {\lstinputlisting[language=Kmelia,
%  basicstyle={\footnotesize \sffamily}, , frame=trBL, framesep=2pt,
%  caption={\kmelia specification \K{#1}}, label={#2}]{#3}}
\newcommand{\specKmelia}[4] {\lstinputlisting[language=Kmelia,
  basicstyle={\footnotesize \sffamily}, , frame=trBL, framesep=2pt,
  caption={\kmelia specification \K{#1}}, label={#2}, linerange={#4}]{#3}}

%-------- Files to put in the repLATEX directory
\usepackage{\repLATEX/zedbis}    % LaTeX/Z utilities
\usepackage{\repLATEX/declar}    % various shortcuts
\usepackage{\repLATEX/a4pasc}    % full page
\def\repBIBLIO{.}                %TO UPDATE BIBLIOGRAPHY REFERENCE DIRECTORY
%\def\repFIGURES{${lctx.outputdir}FIGURES}       % DOT/EPS FIGURE DIRECTORY
\def\repFIGURES{./FIGURES}       % problem with absolute names
\usepackage{multicol}
\usepackage{url}
%-------- Local Definitions
\newcounter{references}           % for the figures
\newcounter{reftab}               % for the tables
\def\kmelia{\textsf{Kmelia}\xspace}

%-------- Title Definitions
\title{\kmelia Specification of ${lctx.name}}
\author{${lctx.author}}
\date{${lctx.datespec}}
\begin{document}
\maketitle
\begin{abstract}
This document has been produced automatically by the COSTO/\kmelia Tex Export tool 
with the template 'Component' alone.\\
~\\ Please insert here your abstract comment ~\\
~\\ \noindent \textbf{Keywords}:~Components, Services, LTS, \kmelia ~\\
\end{abstract}
\newpage
\tableofcontents
\newpage
\section{Kmelia specification of component ${lctx.name}.}

This document presents the specification of the component ${lctx.name}.

It was generated automatically using the \texttt{Kml2Tex} generator of 
the COSTO tool\footnote{\url{http://www.lina.sciences.univ-nantes.fr/coloss/softwares/index.php}}.

The composite template has not been selected here.

\subsection{Component ${lctx.name}}

\paragraph{Description of the Component ${lctx.name}}~\\

This section includes the user comment of the component ${lctx.name}.

<#assign comment = comment>

%problems of carriage return and math mode => listings

 \begin{lstlisting}[language=Kmelia,basicstyle={\footnotesize
    \sffamily},frame=trBL,framesep=2pt]
${comment}
\end{lstlisting}

\todo{Visual representation of the interface to be generated later}

%\begin{figure}[!ht]
%  \centerline{\includegraphics[width=0.85\textwidth]{.\repFIGURES/${lctx.component.name}.eps}}
%  \caption{Simplified Representation of the ${lctx.name} component interface
%  \label{${lctx.component.name}_fig}} 
%\end{figure}


\subsubsection{State Space}

This section describes the component state space (types, state variables, invariant and properties).

<#assign spec = cSpec>
 \begin{lstlisting}[language=Kmelia,basicstyle={\footnotesize
    \sffamily},frame=trBL,framesep=2pt]
${spec}
\end{lstlisting}

<#list servList as s> <#-- begin servList -->
\subsubsection{Service ${s.name}}

${s.comment}

 \begin{lstlisting}[language=Kmelia,basicstyle={\footnotesize
    \sffamily},frame=trBL,framesep=2pt]
${s.spec}
\end{lstlisting}
<#if s.outfilename != "no LTS output">
%\begin{center}
%\centerline{\epsfig{figure=\repFIGURES/${s.outfilename}.eps,width=${s.size}cm}}
%\legende{${lctx.component.name}_${s.name}_eps}{Labelled Transition System of service \texttt{${s.name}}}
%\end{center}

\begin{figure}[!ht]
  \centerline{\includegraphics[width=0.85\textwidth]{.\repFIGURES/${s.outfilename}.png}}
  \caption{Labelled Transition System of service \texttt{${s.name}}
  \label{${lctx.component.name}_${s.name}_fig}} 
\end{figure}

</#if>
</#list> <#-- end servList -->

<#if composition> <#-- begin composition -->

\subsubsection{Composition}

This section describes the component composition (assembly and promotion).

\paragraph{Specification}~\\

<#assign compositionSpec = compositionSpec>
 \begin{lstlisting}[language=Kmelia,basicstyle={\footnotesize
    \sffamily},frame=trBL,framesep=2pt]
${compositionSpec}
\end{lstlisting}

%\paragraph{Assembly}~\\

</#if> <#-- composition -->

\subsection{Synthesis}

Some metrics :
\begin{itemize}
   \item number of provided services:
   \item number of required services:
   \item number of internal services:
\end{itemize}


\listoffigures
%\listoftables
\lstlistoflistings
%\appendix
%\printindex
\end{document}

