COMPONENT ${tester_name}
INTERFACE  
  provides : {${testcase}}
  requires : {${sut.sid.varName}<#list outputAssignments?keys as outp><#if outputAssignments[outp]?has_content && outputAssignments[outp].sid.varName!=sut.sid.varName>, ${outputAssignments[outp].sid.varName}</#if> </#list>} 
  autorun: {${testcase}}
USES {${costoLibs}} 
 <#assign sut_params = sut.servParams>
VARIABLES    
  obs verdict: Boolean ;
#SUT variables
<#list sut.variables?if_exists as variable>
<#if sut_params[variable.name]?has_content>
  ${sut_params[variable.name].name}: ${sut_params[variable.name].type};
</#if> 
</#list>
#oracle variables
<#list oracleVariables?values as variable>
<#if variable.name!=sut.result.name>
  ${variable.name}: ${variable.type};
</#if> 
</#list>
#Result variable if the service result was not set
${sut.result.name}: ${sut.result.type};

INITIALIZATION
#oracle variables initialisation
<#list oracleVariables?values as variable>
<#if outputAssignments[variable.name]?has_content>
<#else>
  ${variable.name}:=getData("${variable.name}", "${variable.type}");
</#if> 
</#list>
#SUT parameters
<#list sut.variables?if_exists as variable>
<#--if outputAssignments[variable.name]?has_content-->
  ${sut_params[variable.name].name}:=getData("${sut_params[variable.name].name}", "${sut_params[variable.name].type}");
<#--/#if-->
</#list>

SERVICES
provided ${testcase} ()
Interface
  extrequires: {${sut.sid.varName}<#list outputAssignments?keys as outp><#if outputAssignments[outp]?has_content && outputAssignments[outp].sid.varName!=sut.sid.varName>, ${outputAssignments[outp].sid.varName}</#if> </#list>}   
Variables
${sut.result.name} : ${sut.result.type};

Sequence
{   
 # init sequence
 # call
 <#if sut_params?has_content>
  ${sut.result.name} := !!${sut.sid.varName}(<#list sut.variables?if_exists as variable> ${sut_params[variable.name].name}<#if variable_has_next> ,</#if> </#list>);
 </#if> 
 #oracle variables from services result
 <#list oracleVariables?values as variable>
<#if variable.name!=sut.result.name && outputAssignments[variable.name]?has_content>
   <#assign tserv = outputAssignments[variable.name]>
  ${variable.name} := !!${tserv.sid.varName}(<#list tserv.variables?if_exists as variable> ${tserv.servParams[variable.name].name}<#if variable_has_next> ,</#if> </#list>);
</#if> 
</#list>
  # oracle evaluation
  verdict:= (<#list intention.properties?keys as prop>${intention.properties[prop]}</#list>);
  # transmit verdict
  assertT(verdict);
  #end of service
  SendResult()
  }
End
required ${sut.sid.varName}(<#list sut.variables?if_exists as variable> ${variable.name}: ${variable.type}<#if variable_has_next> ,</#if> </#list>) : ${sut.service.returnCostoType.name}
End

<#list outputAssignments?keys as outp>
 <#if outputAssignments[outp]?has_content && outputAssignments[outp].sid.varName!=sut.sid.varName>
<#assign tserv = outputAssignments[outp]>

required ${tserv.sid.varName}(<#list tserv.variables?if_exists as variable> ${variable.name}: ${variable.type}<#if variable_has_next> ,</#if> </#list>) : ${tserv.service.returnCostoType.name}
End
 </#if> 
</#list>
END_SERVICES
