header
{
package mec.grammar;
}
//TODO problems with quotes and \ in guards, problems with nops after guards
class AnalyserLexMec extends Lexer;

options { k=3; }

protected DIGIT : '0'..'9';
protected UNDER : '_';
protected LETTER : 'a'..'z' | 'A'..'Z' ;
protected LINE : "//" ;

KEYWORD_DTS : "dts";
PROP : "---";
NUMBER : DIGIT (DIGIT)*;
//WORD : LETTER (DIGIT | LETTER | UNDER)* ;
WORD : (LETTER | UNDER) (DIGIT | LETTER | UNDER)* ;

ARROW_START : "|-";
ARROW_END : "->" ;
COMMA : ',';
SEMICOLON : ';';
STAR : '*';
BLOCK_START : '{';
BLOCK_END : '}';
PAR_START : '(';
PAR_END : ')';
EQ : "=";
COLON : ':';
QUOT_MARK : '\"';
PERIOD : '.';
INF : '<';
SUP : '>';
WS    :
    ( ' ' 
    | '\t' 
    | '\r' '\n' { newline(); } 
    | '\n'      { newline(); }
    | LINE
    ) 
    { $setType(Token.SKIP); } ;
	{
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.io.FileReader;
import java.util.HashSet;
import mec.graph.*; 
}

/*
* Analyseur syntaxique d'un fsm MEC
*/
class AnalyserSynMec extends Parser;
options {defaultErrorHandler=true;k=3;}

//---------------------------------------------------------------- COMPONENTS --------------------------

//PA : a Mec result has 6 parts 

mec_result returns [MecRes mr = null] {MecResHeader head=null; HashMap<String,Integer> states_prop=null; HashMap states_set=null; MecResSTS sts; HashMap<String,Integer> transitions_prop=null;} : 
head = mecheader 
PROP "States" COLON states_prop=prop_list 
PROP "Transitions" COLON transitions_prop=prop_list 
"wts" PAR_START STAR COMMA STAR PAR_END SEMICOLON
sts=fsm
INF states_set=prop_list_states
SUP PERIOD
"stoplog" PAR_START PAR_END SEMICOLON
{	mr=new MecRes(head, states_prop, transitions_prop, sts, states_set);
};  

//header : Mec Res header 
mecheader returns [MecResHeader h = new MecResHeader()] {String version = ""; String current = ""; }:
"version" PAR_START PAR_END SEMICOLON 
"MEC" nu:NUMBER {version+= "MEC "+nu.getText();}
"version" ve:WORD venu: NUMBER {version+= " version "+ve.getText()+" "+venu.getText();}
(PERIOD venus:NUMBER {version+= "."+Integer.parseInt(venus.getText());})*
//{System.out.println(">>version: "+version);}
KEYWORD_DTS PAR_START stsname:WORD PAR_END SEMICOLON
//{System.out.println(">>stsname: "+stsname.getText()); }
(cu:WORD {current+= cu.getText(); } | cun:NUMBER {current+= " "+Integer.parseInt(cun.getText());})*
COLON stsnamea:WORD {current+= " : "+stsnamea.getText();}
//{System.out.println(">>current: "+current); }
{h = new MecResHeader(stsname.getText(), version, current);}
;

//prop_list : Mec properties (with number of states or transitions)
prop_list returns [HashMap<String,Integer> pl = new HashMap<String,Integer>()] {String pr = "";}:
((p:WORD {pr = p.getText();} | STAR {pr = "*";})
COLON n:NUMBER {pl.put(pr,new Integer(Integer.parseInt(n.getText())));})*
;

//prop_list_states : Mec properties (with set of states)
prop_list_states returns [HashMap<String,HashSet<MecResState>> ls = new HashMap<String,HashSet<MecResState>> ()] {HashSet<MecResState> s, ss;} :
(
(p:WORD EQ s = setofstates {ls.put(p.getText(),s);})
(COMMA pr:WORD EQ ss = setofstates {ls.put(pr.getText(),ss);})*
)?
{System.out.println("list_states= "+ls.toString());}
;

//setofstates : set of states
setofstates returns [HashSet<MecResState> sos = new HashSet<MecResState>()] {MecResState s,ss;} :
BLOCK_START 
((s = state {sos.add(s);})
(COMMA ss = state {sos.add(ss);})*
)? 
BLOCK_END
//{System.out.println("sos= "+sos.toString());}
;

//state : state (mec) name
state returns [MecResState st = null] {ArrayList<String> sl;} :
(e:WORD 
//{if (errverbose) 
{if (!(e.getText().equals("e"))) System.err.println(">>warning: "+e+" <> 'e'");}
)//;}
// TODO  throw exception
(a:PAR_START (sl = name_list {st = new MecResState(sl);}) b:PAR_END
)
//{System.out.println("etat: "+st.toString());}
;

name_list returns [ArrayList<String> snl=new ArrayList<String>()] :
  s1:WORD {snl.add(s1.getText());}(PERIOD s2:WORD {snl.add(s2.getText());})*
;

//sts description
fsm returns [MecResSTS sts=null;] {
ArrayList sync_lts=null; MecResLTS lts;}:
 "transition_system" 
 name:WORD
 INF "width"
 EQ
 width:NUMBER
 SEMICOLON
 "list"
 EQ
 a:PAR_START (sync_lts = lts_list)? b:PAR_END 
 SUP
 SEMICOLON
 lts=trans_list
 { sts=new MecResSTS(name.getText(), Integer.parseInt(width.getText()), sync_lts, lts);
 }
;  

//list of LTS of the synchronized product
lts_list returns [ArrayList<String> ll=new ArrayList<String>()] :
  lts1:WORD {ll.add(lts1.getText());}(COMMA lts2:WORD {ll.add(lts2.getText());})*;

//list of transitions of the synchronized product
trans_list returns [MecResLTS lts = new MecResLTS()] {ArrayList tr=new ArrayList();}:
 (tr=transition_line {lts.addFSMFSMTransition(tr);} 
 SEMICOLON 
 //attention tr a t potentiellement modifi
 {System.out.println("trans: "+tr.toString());}
 )*
;
 
//a transition
 transition_line returns [ArrayList<MecResTransition> trlist = new ArrayList<MecResTransition>();] {MecResState st1, st2, st3; ArrayList<String> label, label1;ArrayList<String> trpr=new ArrayList<String>();}:
 st1 = state ARROW_START 
 {System.out.println("st1: "+st1.toString());}
 (PAR_START label = name_list PAR_END
 ARROW_END st2=state 
 {System.out.println("st2: "+st2.toString());}
 (trpr=transition_prop)?
 {trlist.add(new MecResTransition(st1,st2,label,trpr));}
 (COMMA 
 PAR_START label1 = name_list PAR_END
 ARROW_END st3=state 
 {System.out.println("st3: "+st3.toString());}
 (trpr=transition_prop)?
 {trlist.add(new MecResTransition(st1,st3,label1,trpr));}
 )*)?
;

//a transition property list => ignored TODO more
 transition_prop returns [ArrayList<String> proplist = new ArrayList<String>();] :
 INF "property" EQ PAR_START 
 proplist = name_list 
 PAR_END
 SUP 
 {System.out.println("proplist: "+proplist.toString());}
;

