/*
 * Decompiled with CFR 0.152.
 */
package costo;

import costo.graph.Component;
import costo.graph.ComponentFactory;
import costo.graph.LTS;
import costo.graph.Service;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class Loader {
    public static Component loadComponent(String component_name) throws Exception {
        Properties userprop = new Properties();
        userprop.load(new FileInputStream("Costolib.userprefs"));
        String specdir = userprop.getProperty("costo.specdir");
        String spec_abs_path = String.valueOf(userprop.getProperty("costo.basedir", String.valueOf(System.getProperty("user.dir")) + "/")) + specdir;
        if (component_name == null || component_name.equals("")) {
            component_name = userprop.getProperty("costo.basecomp");
        }
        return Loader.loadComponent(spec_abs_path, component_name);
    }

    public static Component loadComponent(String spec_abs_path, String component_name) throws Exception {
        ComponentFactory cf = new ComponentFactory("mafactory", spec_abs_path);
        Component comp = cf.getComponent(component_name);
        return comp;
    }

    public static Component loadComponent() throws Exception {
        String[] nothing = null;
        return Loader.loadComponent(nothing);
    }

    public static Component loadComponent(String[] args) throws Exception {
        String spec_dir = "";
        String comp_name = "";
        String base_dir = "";
        if (args == null || args.length < 3) {
            try {
                Properties userprop = new Properties();
                userprop.load(new FileInputStream(String.valueOf(System.getProperty("user.dir")) + "/Costolib.userprefs"));
                spec_dir = userprop.getProperty("costo.specdir");
                comp_name = userprop.getProperty("costo.basecomp");
                base_dir = userprop.getProperty("costo.basedir", String.valueOf(System.getProperty("user.dir")) + "/");
            }
            catch (Exception exception) {
                System.err.println("Preference file Costolib.userprefs not found");
                System.out.println("Please create this file or give relative specification path then component name as parameters");
            }
        }
        if (args.length > 0) {
            spec_dir = args[0];
        }
        if (args.length > 1) {
            comp_name = args[1];
        }
        if (args.length > 2) {
            base_dir = args[2];
        }
        System.out.println("The base dir is " + base_dir);
        System.out.println("The spec dir is " + spec_dir);
        System.out.println("The main component is " + comp_name);
        return Loader.loadComponent(String.valueOf(base_dir) + spec_dir, comp_name);
    }

    public static Component loadComponent(String compname, ComponentFactory factory) {
        return null;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        try {
            Component comp = Loader.loadComponent(args);
            System.out.println("---------------------------\n Component contents : \n");
            System.out.println(comp);
            Properties trialprop = new Properties();
            trialprop.load(new FileInputStream("Costolib.userprefs"));
            String main_serv = trialprop.getProperty("costo.mainserv");
            System.out.println("---------------------------\n Service handling : " + main_serv);
            Service baseserv = comp.getService(main_serv);
            System.out.println("base serv : " + baseserv.toString());
            System.out.println("##########################################");
            System.out.println(baseserv.getBehavior());
            LTS a = new LTS(baseserv.getBehavior());
            a.expandSubServices("TOTO");
            System.out.println(a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

