/*
 * Decompiled with CFR 0.152.
 */
package costo.checks.errorLogger;

import costo.checks.errorLogger.KmlError;
import costo.graph.ComponentFactory;
import java.util.ArrayList;
import java.util.HashMap;

public class KmlLogger {
    private HashMap<Object, ArrayList<KmlError>> errorsBySource = new HashMap();
    private HashMap<String, ArrayList<KmlError>> errorsByType = new HashMap();
    private HashMap<String, KmlError> errorsByID = new HashMap();
    private ComponentFactory compfactory;

    public KmlLogger(ComponentFactory compfactory) {
        this.compfactory = compfactory;
    }

    public void log(KmlError error) {
        ArrayList<KmlError> list = this.errorsBySource.get(error.getSource());
        if (list == null) {
            list = new ArrayList();
        }
        list.add(error);
        this.errorsByID.put("err" + error.hashCode(), error);
        this.errorsBySource.put(error.getSource(), list);
        ArrayList<KmlError> list2 = this.errorsByType.get(error.getErrortype());
        if (list2 == null) {
            list2 = new ArrayList();
        }
        list2.add(error);
        this.errorsByType.put(error.getErrortype(), list2);
    }

    public void log(String message, Object source, String errortype, int line, int column, String filename) {
        if (filename == null || filename.length() == 0) {
            filename = this.compfactory.getCurrentFile();
        }
        this.log(new KmlError(message, source, errortype, line, column, filename));
    }

    public HashMap<Object, ArrayList<KmlError>> getErrorsBySource() {
        return this.errorsBySource;
    }

    public HashMap<String, ArrayList<KmlError>> getErrorsByType() {
        return this.errorsByType;
    }

    public String dumpAllErrors() {
        StringBuffer sb = new StringBuffer();
        for (ArrayList<KmlError> errors : this.errorsByType.values()) {
            for (KmlError kmlError : errors) {
                sb.append(kmlError);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public KmlError get(Object key) {
        return this.errorsByID.get(key);
    }
}

