/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.Component;
import java.util.ArrayList;
import java.util.Iterator;

public class ComponentInstance {
    private Component type;
    private String name;
    private ComponentInstance owner;
    private ArrayList<ComponentInstance> subinstances;

    public ComponentInstance(Component type, String name) {
        this.type = type;
        this.name = name;
        this.subinstances = new ArrayList();
    }

    public ComponentInstance getOwner() {
        return this.owner;
    }

    public void setOwner(ComponentInstance instance) {
        this.owner = instance;
    }

    public Component getType() {
        return this.type;
    }

    public void setType(Component type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Iterator<ComponentInstance> getSubinstances() {
        return this.subinstances.iterator();
    }

    public void addSubInstance(ComponentInstance ci) {
        this.subinstances.add(ci);
        ci.setOwner(this);
    }

    public void setSubinstances(ArrayList<ComponentInstance> subinstances) {
        this.subinstances = subinstances;
    }

    protected String toIndentString(String indent) {
        String s = "";
        s = String.valueOf(indent) + this.name + " : " + this.type.getName() + "\n";
        for (ComponentInstance element : this.subinstances) {
            s = String.valueOf(s) + element.toIndentString(String.valueOf(indent) + "  ");
        }
        return s;
    }

    public String toString() {
        return this.toIndentString("");
    }
}

