/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.checks.errorLogger.KmlLogger;
import costo.graph.KmlContext;
import costo.graph.KmlStructuralElement;
import costo.graph.Variable;
import costo.graph.VerificationCode;
import costo.graph.expressions.KmlAssignmentExpression;
import java.util.HashMap;
import java.util.Map;

public class InitializationsClause
extends KmlStructuralElement {
    private HashMap<String, KmlAssignmentExpression> initializations;

    public InitializationsClause(HashMap<String, KmlAssignmentExpression> initializations) {
        this.initializations = initializations;
    }

    public InitializationsClause() {
    }

    public HashMap<String, KmlAssignmentExpression> getInitializations() {
        return this.initializations;
    }

    public void setInitializations(HashMap<String, KmlAssignmentExpression> initializations) {
        this.initializations = initializations;
    }

    @VerificationCode
    void resolve(KmlContext context, KmlLogger kmlLogger, String filepath) {
        if (this.getInitializations() == null) {
            return;
        }
        for (Map.Entry<String, KmlAssignmentExpression> element : this.getInitializations().entrySet()) {
            Variable var = context.lookupVariable(element.getKey());
            if (var == null) {
                kmlLogger.log("Undeclared variable " + element.getKey() + " initialized in component " + context.getName(), context, "RESOLUTION ERROR", element.getValue().getLine(), element.getValue().getColumn(), filepath);
                continue;
            }
            element.getValue().resolveType(context);
        }
    }
}

