/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.KmlElement;
import costo.graph.Service;
import costo.graph.Spec;
import costo.graph.Transition;
import costo.graph.expressions.AbstractExpressionVisitor;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlCondition;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlMandatoryCall;
import costo.graph.expressions.KmlTypedStuff;
import costo.graph.visitors.KmlElementVisitor;
import costo.graph.visitors.LabelFieldSynchronisationExpressionVisitor;

public class Label
extends KmlElement {
    protected KmlExpression expression;
    protected KmlCondition guard;
    protected LabelFieldSynchronisationExpressionVisitor visitor = new LabelFieldSynchronisationExpressionVisitor();
    protected boolean visitNeeded = true;

    public Label() {
    }

    public Label(KmlExpression expression) {
        this.expression = expression;
    }

    public Label(Label aLabel) {
        this();
        if (aLabel.guard != null) {
            this.guard = (KmlCondition)aLabel.guard.deepCopy();
        }
        if (aLabel.expression != null) {
            this.expression = aLabel.expression.deepCopy();
        }
    }

    public void checkVariables(Service context, Transition line) {
        this.typeCheckExpressions(context);
    }

    private void typeCheckExpressions(Service context) {
        if (this.guard != null) {
            this.guard.resolveType(context);
        }
        if (this.expression != null) {
            this.expression.resolveType(context);
        }
    }

    public int getActionType() {
        if (this.visitNeeded) {
            this.revisit();
        }
        return this.visitor.getActionType();
    }

    public String getChannel() {
        if (this.visitNeeded) {
            this.revisit();
        }
        if (this.visitor.getInterlocutorSet() == null) {
            return null;
        }
        return this.visitor.getInterlocutorSet().getChannel();
    }

    private void revisit() {
        if (this.expression != null) {
            this.expression.accept(this.visitor);
        }
        this.visitNeeded = false;
    }

    public Boolean isGuarded() {
        if (this.guard != null) {
            return true;
        }
        return false;
    }

    public KmlExpression getExpression() {
        return this.expression;
    }

    public KmlCondition getGuard() {
        return this.guard;
    }

    public String getMessage() {
        if (this.visitNeeded) {
            this.revisit();
        }
        return this.visitor.getMessage();
    }

    public String getRawLabel() {
        return this.toString();
    }

    public String getStringActionType() {
        return Spec.getActionType(this.getActionType());
    }

    public void redirectCaller(final String channame) {
        this.expression.accept(new AbstractExpressionVisitor(){

            @Override
            public void defaultExpressionOperation(KmlTypedStuff expr) {
            }

            @Override
            public boolean visit(KmlCommunication expression) {
                expression.getInterlocutorSet().setChannel(channame);
                return false;
            }

            @Override
            public boolean visit(KmlMandatoryCall expression) {
                expression.getInterlocutorSet().setChannel(channame);
                return false;
            }
        });
    }

    public void setExpression(KmlExpression expression) {
        this.expression = expression;
    }

    public void setGuard(KmlCondition guard) {
        this.guard = guard;
    }

    public String toString() {
        String s = "";
        if (this.guard != null) {
            s = String.valueOf(s) + this.guard.asGuard();
        }
        s = this.expression != null ? String.valueOf(s) + this.expression.getRawValue() : String.valueOf(s) + "nop";
        return s;
    }

    public Label twin() {
        return new Label(this);
    }

    @Override
    public void accept(KmlElementVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.guard != null) {
                this.guard.accept(visitor.getExpressionVisitor());
            }
            if (this.expression != null) {
                this.expression.accept(visitor.getExpressionVisitor());
            }
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.guard == null ? 0 : this.guard.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Label)) {
            return false;
        }
        Label other = (Label)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return !(this.guard == null ? other.guard != null : !this.guard.equals(other.guard));
    }
}

