/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.InterlocutorSet;
import costo.graph.LTS;
import costo.graph.Label;
import costo.graph.Spec;
import costo.graph.State;
import costo.graph.Transition;
import costo.graph.expressions.KmlCommunication;
import java.util.ArrayList;

public class PipeOperator {
    private String chan1;
    private String chan2;
    private String heading;

    public PipeOperator(String chan1, String chan2) {
        this.chan1 = chan1;
        this.chan2 = chan2;
        this.heading = String.valueOf(chan1) + "_pipe_" + chan2;
    }

    public String toString() {
        return String.valueOf(this.chan1) + "<|>" + this.chan2;
    }

    public void generateLTS(LTS support, Transition supportTransition, ArrayList<String> callersends, ArrayList<String> callerreceptions, ArrayList<String> callerservicecalls) {
        int number = 0;
        State start = supportTransition.getSource();
        for (String callersend : callersends) {
            this.addCallerSend(support, start, callersend, 8, this.chan1, this.chan2, number++);
        }
        for (String callerreceive : callerreceptions) {
            this.addCallerSend(support, start, callerreceive, 8, this.chan2, this.chan1, number++);
        }
        for (String callerservcall : callerservicecalls) {
            this.addCallerSend(support, start, callerservcall, 2, this.chan2, this.chan1, number++);
        }
        for (String callerservcall : callerservicecalls) {
            if (callerservcall.equalsIgnoreCase(this.chan2)) continue;
            this.addCallerSend(support, start, callerservcall, 2, this.chan2, this.chan1, number++);
            this.addCallerSend(support, start, callerservcall, 4, this.chan2, this.chan1, number++);
        }
        Label getendrequired = new Label();
        KmlCommunication getendreq = new KmlCommunication(new InterlocutorSet(this.chan2), 4, this.chan2, null);
        getendrequired.setExpression(getendreq);
        Label sendendrequired = new Label();
        KmlCommunication sendendreq = new KmlCommunication(new InterlocutorSet(this.chan1), 32, this.chan2, null);
        sendendrequired.setExpression(sendendreq);
        State s = new State(String.valueOf(this.heading) + number);
        Transition getend = new Transition(start, s, getendrequired);
        Transition setend = new Transition(s, supportTransition.getTarget(), sendendrequired);
        support.addState(s);
        support.addTransition(getend);
        support.addTransition(setend);
        support.removeTransition(supportTransition);
    }

    private void addCallerSend(LTS lts, State start, String msend, int actiontype, String callerchan, String calledchan, int number) {
        Label reception = new Label();
        KmlCommunication getendreq = new KmlCommunication(new InterlocutorSet(callerchan), actiontype, msend, null);
        reception.setExpression(getendreq);
        Label send = new Label();
        KmlCommunication sendendreq = new KmlCommunication(new InterlocutorSet(calledchan), Spec.reverseActionType(actiontype), msend, null);
        send.setExpression(sendendreq);
        State s = new State(String.valueOf(this.heading) + number);
        Transition tReception = new Transition(start, s, reception);
        Transition tSend = new Transition(s, start, send);
        lts.addState(s);
        lts.addTransition(tReception);
        lts.addTransition(tSend);
    }
}

