/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.Component;
import costo.graph.Variable;
import costo.graph.expressions.Localizable;
import costo.graph.types.CostoType;

public class PromotedVariable
extends Variable
implements Localizable {
    private Component comp;
    private String compVarName;
    private String sourceVarName;
    private Variable origin;
    int line;
    int column;

    @Override
    public boolean isSimple() {
        return false;
    }

    public PromotedVariable(String name, String compname, String sourceVarName) {
        super(name, null);
        this.compVarName = compname;
        this.sourceVarName = sourceVarName;
        this.setConstant(false);
        this.setWritable(false);
    }

    public Variable getOrigin() {
        return this.origin;
    }

    public void setOrigin(Variable origin) {
        this.origin = origin;
    }

    public String getCompVarName() {
        return this.compVarName;
    }

    public String getSourceVarName() {
        return this.sourceVarName;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public void setColumn(int column) {
        this.column = column;
    }

    @Override
    public String getPositionAsText() {
        return "line: " + this.line + " column: " + this.column;
    }

    public Component getComp() {
        return this.comp;
    }

    public void setComp(Component comp) {
        this.comp = comp;
    }

    @Override
    public CostoType getCtype() {
        if (this.origin == null) {
            return null;
        }
        return this.origin.getCtype();
    }

    @Override
    public String toString() {
        this.getOrigin();
        String s = String.valueOf(this.getName()) + " From " + this.compVarName + "." + this.sourceVarName;
        return s;
    }
}

