/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.KmlElement;
import costo.graph.ServiceHook;
import costo.graph.Spec;
import costo.graph.Transition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class State
extends KmlElement {
    private LinkedList<Transition> outGoingTransitions;
    private LinkedList<Transition> inComingTransitions;
    private ArrayList<ServiceHook> services = new ArrayList();

    public State() {
        this.setName("");
        this.outGoingTransitions = new LinkedList();
    }

    public State(State clone) {
        this.setName(clone.getName());
        this.outGoingTransitions = (LinkedList)clone.outGoingTransitions.clone();
        this.inComingTransitions = (LinkedList)clone.inComingTransitions.clone();
        this.services = (ArrayList)clone.services.clone();
    }

    public State twin() {
        return new State(this);
    }

    public State(String id) {
        this.setName(id);
        this.outGoingTransitions = new LinkedList();
        this.inComingTransitions = new LinkedList();
    }

    public String toLongString() {
        String s = this.getName();
        if (this.services != null) {
            s = String.valueOf(s) + Spec.listToString(this.services, "<", ",", ">");
        }
        return s;
    }

    public void addOutGoingTransition(Transition as) {
        if (!this.outGoingTransitions.contains(as)) {
            this.outGoingTransitions.add(as);
            as.setSource(this);
        }
    }

    public void addOutGoingTransitions(LinkedList<Transition> list) {
        for (Transition nt : list) {
            this.addOutGoingTransition(nt);
        }
    }

    public void addInComingTransitions(LinkedList<Transition> list) {
        for (Transition nt : list) {
            this.addInComingTransition(nt);
        }
    }

    public int getOutGoingDegree() {
        return this.outGoingTransitions.size();
    }

    public Iterator<Transition> iteratorOnOutGoingTransitions() {
        return this.outGoingTransitions.iterator();
    }

    public LinkedList<Transition> getOutGoingTransitions() {
        return this.outGoingTransitions;
    }

    public void addService(ServiceHook s) {
        this.services.add(s);
    }

    public ArrayList<ServiceHook> getServices() {
        return this.services;
    }

    public ServiceHook getService(int i) {
        return this.services.get(i);
    }

    public void setService(ArrayList<ServiceHook> al) {
        this.services = new ArrayList();
        if (al == null) {
            return;
        }
        int i = 0;
        while (i < al.size()) {
            this.services.add(al.get(i));
            ++i;
        }
    }

    public void updateServices(State n) {
        if (!this.getName().equals(n.getName())) {
            return;
        }
        if (this.services == null) {
            this.services = new ArrayList();
        }
        if (n.getServices() != null) {
            for (ServiceHook serv : n.getServices()) {
                if (this.services.contains(serv)) continue;
                this.services.add(serv);
            }
        }
        for (Transition arc : n.getOutGoingTransitions()) {
            if (this.outGoingTransitions.contains(arc)) continue;
            this.outGoingTransitions.add(arc);
        }
    }

    public LinkedList<Transition> getInComingTransitions() {
        return this.inComingTransitions;
    }

    public void setInComingTransitions(LinkedList<Transition> inComingTransitions) {
        if (inComingTransitions == null) {
            inComingTransitions = new LinkedList();
        }
        this.inComingTransitions = inComingTransitions;
    }

    public void addInComingTransition(Transition temp) {
        if (!this.inComingTransitions.contains(temp)) {
            this.inComingTransitions.add(temp);
            temp.setTarget(this);
        }
    }

    public void setOutGoingTransitions(LinkedList<Transition> outGoingTransitions) {
        if (outGoingTransitions == null) {
            outGoingTransitions = new LinkedList();
        }
        this.outGoingTransitions = outGoingTransitions;
    }

    public boolean equals(Object obj) {
        if (obj instanceof State) {
            State other = (State)obj;
            return other.getName().equals(this.getName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

