/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.KmlElement;
import costo.graph.Label;
import costo.graph.State;
import costo.graph.visitors.KmlElementVisitor;

public class Transition
extends KmlElement {
    private State source;
    private State target;
    private Label label;
    private int optindex;

    public Transition() {
        this.label = new Label();
    }

    public Transition(Transition t) {
        this.label = t.label.twin();
        this.source = t.source;
        this.target = t.target;
    }

    public Transition twin() {
        return new Transition(this);
    }

    public Transition(State source, State target) {
        this.label = new Label();
        this.setSource(source);
        this.setTarget(target);
    }

    public Transition(State source, State target, Label label) {
        this.label = label;
        this.setSource(source);
        this.setTarget(target);
    }

    public String toString() {
        return String.valueOf(this.source.getName()) + "--" + this.label + "-->" + this.target.getName();
    }

    public State getTarget() {
        return this.target;
    }

    @Override
    public String getName() {
        return String.valueOf(this.source.getName()) + "-" + this.getLabel().toString() + "-" + this.target.getName();
    }

    public void setTarget(State target) {
        this.target = target;
    }

    public State getSource() {
        return this.source;
    }

    public void setSource(State source) {
        this.source = source;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    @Override
    public void accept(KmlElementVisitor visitor) {
        if (visitor.visit(this)) {
            this.source.accept(visitor);
            this.label.accept(visitor);
            this.target.accept(visitor);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Transition) {
            Transition other = (Transition)obj;
            if (!other.source.equals(this.source) || !other.target.equals(this.target)) {
                return false;
            }
            if (other.label == null ^ this.label == null) {
                return false;
            }
            return this.label == null || other.label.equals(this.label);
        }
        return false;
    }

    public int getOptindex() {
        return this.optindex;
    }

    public void setOptindex(int optindex) {
        this.optindex = optindex;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

