/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlConstant;
import costo.graph.expressions.KmlExpression;
import costo.graph.types.CostoArray;
import costo.graph.types.CostoInteger;
import costo.graph.types.CostoRange;
import costo.graph.types.CostoType;

public class KmlArrayExpression
extends KmlExpression {
    private KmlExpression leftPart;
    private KmlExpression index;

    public KmlArrayExpression(KmlExpression leftPart, KmlExpression index) {
        this.leftPart = leftPart;
        this.setLine(leftPart.getLine());
        this.setColumn(leftPart.getColumn());
        this.index = index;
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public KmlExpression getLeftPart() {
        return this.leftPart;
    }

    public void setLeftPart(KmlExpression leftPart) {
        this.leftPart = leftPart;
    }

    public KmlExpression getIndex() {
        return this.index;
    }

    public void setIndex(KmlExpression index) {
        this.index = index;
    }

    @Override
    public String getRawValue() {
        return String.valueOf(this.leftPart.getRawValue()) + "[" + this.index.getRawValue() + "]";
    }

    @Override
    public CostoType getType() {
        if (!(this.leftPart.getType() instanceof CostoArray)) {
            return this.leftPart.getType();
        }
        return ((CostoArray)this.leftPart.getType()).getReftype();
    }

    @Override
    public boolean resolveType(KmlContext context) {
        boolean istyped = this.leftPart.resolveType(context);
        if (istyped && !(this.leftPart.getType() instanceof CostoArray)) {
            context.getLogger().log(" in " + this + " : " + this.leftPart + "is not an array", this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
            return false;
        }
        boolean indextyped = this.index.resolveType(context);
        if (indextyped && !this.typeCheckAgainst(this.index, CostoInteger.instance) && !this.typeCheckAgainst(this.index, CostoRange.instance)) {
            context.getLogger().log(" in " + this + " : " + this.index + " is typed as " + this.index.getType() + "which is not a correct index type", this, "TYPE ERROR", this.index.getLine(), this.index.getColumn(), context.getFilePath());
            return istyped;
        }
        if (istyped && this.index instanceof KmlConstant && !((CostoArray)this.leftPart.getType()).isInRange(this.index.getRawValue())) {
            context.getLogger().log(" in " + this + " : " + this.index + " is not in " + ((CostoArray)this.leftPart.getType()).getRange(), this, "TYPE ERROR", this.index.getLine(), this.index.getColumn(), context.getFilePath());
        }
        return istyped;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            this.leftPart.accept(visitor);
            this.index.accept(visitor);
        }
    }

    @Override
    public KmlExpression deepCopy() {
        KmlArrayExpression twin = new KmlArrayExpression(this.leftPart.deepCopy(), this.index.deepCopy());
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        twin.setLine(this.getLine());
        twin.setColumn(this.getColumn());
        return twin;
    }
}

