/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.Variable;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlArrayExpression;
import costo.graph.expressions.KmlBinOP;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlIdentifier;
import costo.graph.types.CostoType;
import costo.graph.types.CostoVoid;

public class KmlAssignmentExpression
extends KmlBinOP {
    public KmlAssignmentExpression(KmlExpression leftOperand, KmlExpression rightOperand) {
        super(leftOperand, rightOperand, ":=");
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            this.leftOperand.accept(visitor);
            this.rightOperand.accept(visitor);
        }
    }

    @Override
    public KmlExpression deepCopy() {
        KmlAssignmentExpression twin = new KmlAssignmentExpression(this.leftOperand.deepCopy(), this.rightOperand.deepCopy());
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        return twin;
    }

    @Override
    public boolean resolveType(KmlContext context) {
        Variable var;
        boolean rightOK = this.rightOperand.resolveType(context);
        boolean leftOK = this.leftOperand.resolveType(context);
        if (rightOK && this.rightOperand instanceof KmlCommunication && ((KmlCommunication)this.rightOperand).getActionType() != 1) {
            context.getLogger().log(" in " + this + " synchronous communication assignment is only legal for service calls var:=chan!!serv(params)", this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
            return false;
        }
        if (leftOK && !(this.leftOperand instanceof KmlArrayExpression) && !(this.leftOperand instanceof KmlIdentifier)) {
            context.getLogger().log(" in " + this + " : " + this.leftOperand + " cannot be assigned a value", this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
            return false;
        }
        if (this.leftOperand instanceof KmlIdentifier && (var = ((KmlIdentifier)this.leftOperand).getVar()) != null && !var.isWritable()) {
            context.getLogger().log(" in " + this + " : " + this.leftOperand + "cannot be assigned a value because" + (var.isConstant() ? " it is a constant" : "it is not writable"), this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
        }
        if (leftOK && rightOK && !this.typeCheckAgainst(this.rightOperand, this.leftOperand.getType())) {
            context.getLogger().log(" in " + this + " : " + this.rightOperand + " of type " + this.rightOperand.getType() + "cannot be assigned to " + this.leftOperand + " of type " + this.leftOperand.getType(), this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
        }
        return true;
    }

    @Override
    public CostoType getType() {
        return CostoVoid.instance;
    }

    @Override
    public boolean isCommunication() {
        return this.rightOperand.isCommunication();
    }

    @Override
    public KmlCommunication getCommunicationAction() {
        if (this.rightOperand instanceof KmlCommunication) {
            return (KmlCommunication)this.rightOperand;
        }
        return null;
    }
}

