/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.Spec;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlExpression;
import costo.graph.types.CostoType;
import costo.graph.types.CostoVoid;
import java.util.ArrayList;
import java.util.Collection;

public class KmlCompositeExpression
extends KmlExpression {
    private ArrayList<KmlExpression> expressions = new ArrayList();
    private String operatorType;

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            for (KmlExpression operand : this.expressions) {
                operand.accept(visitor);
            }
        }
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public KmlCompositeExpression(String operatorType) {
        this.operatorType = operatorType;
    }

    @Override
    public CostoType getType() {
        return CostoVoid.instance;
    }

    @Override
    public KmlExpression deepCopy() {
        ArrayList<KmlExpression> twinops = null;
        if (this.expressions != null) {
            twinops = new ArrayList<KmlExpression>();
            for (KmlExpression kmlExpression : this.expressions) {
                twinops.add(kmlExpression.deepCopy());
            }
        }
        KmlCompositeExpression twin = new KmlCompositeExpression(this.operatorType);
        twin.setExpressions(twinops);
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        twin.setLine(this.getLine());
        twin.setColumn(this.getColumn());
        return twin;
    }

    public void setExpressions(ArrayList<KmlExpression> expressions) {
        this.expressions = expressions;
        if (expressions == null) {
            return;
        }
        this.setColumn(expressions.get(0).getColumn());
        this.setLine(expressions.get(0).getLine());
        String s = Spec.listToString(expressions, "", " " + this.operatorType + " ", "");
        this.setRawValue(s);
    }

    public boolean add(KmlExpression e) {
        return this.expressions.add(e);
    }

    public boolean addAll(Collection<? extends KmlExpression> c) {
        return this.expressions.addAll(c);
    }

    public String getOperatorType() {
        return this.operatorType;
    }

    public void setOperatorType(String operatorType) {
        this.operatorType = operatorType;
    }

    @Override
    public boolean resolveType(KmlContext context) {
        boolean ok = true;
        for (KmlExpression operand : this.expressions) {
            boolean newok = operand.resolveType(context);
            boolean bl = ok = ok && newok;
            if (operand.getType() != null && operand.getType().conformsTo(CostoVoid.instance)) continue;
            context.getLogger().log(operand + " is not a statement. " + operand.getType() + " found, type Void expected.", this, "TYPE ERROR", operand.getLine(), operand.getColumn(), context.getFilePath());
        }
        return ok;
    }

    public ArrayList<KmlExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public String getRawValue() {
        return Spec.listToString(this.expressions, "{", this.operatorType, "}");
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public boolean isCommunication() {
        if (this.expressions != null) {
            for (KmlExpression kmlExpression : this.expressions) {
                if (!kmlExpression.isCommunication()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public KmlCommunication getCommunicationAction() {
        if (this.expressions != null) {
            for (KmlExpression kmlExpression : this.expressions) {
                if (!kmlExpression.isCommunication()) continue;
                return (KmlCommunication)kmlExpression;
            }
        }
        return null;
    }
}

