/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.types.CostoBoolean;
import costo.graph.types.CostoType;

public class KmlCondition
extends KmlExpression {
    private boolean value = true;
    private String term = "";
    private boolean evaluated = false;
    private KmlExpression expression;

    public KmlCondition(KmlExpression expression) {
        this.expression = expression;
        this.setColumn(expression.getColumn());
        this.setLine(expression.getLine());
        this.term = expression.getRawValue();
    }

    public KmlCondition() {
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public KmlExpression deepCopy() {
        return new KmlCondition(this.expression.deepCopy());
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            this.expression.accept(visitor);
        }
    }

    public KmlCondition(boolean value, String term) {
        this.value = value;
        this.evaluated = true;
        this.term = term;
    }

    public KmlCondition(String term) {
        this.term = term;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
        this.evaluated = true;
    }

    public boolean isEvaluated() {
        return this.evaluated;
    }

    public KmlExpression getExpression() {
        return this.expression;
    }

    public void setExpression(KmlExpression expression) {
        this.expression = expression;
    }

    public void setEvaluated(boolean evaluated) {
        this.evaluated = evaluated;
    }

    @Override
    public String getRawValue() {
        return this.expression != null ? this.expression.getRawValue() : "";
    }

    public String asGuard() {
        return "[" + this.getRawValue() + "]";
    }

    @Override
    public CostoType getType() {
        return CostoBoolean.instance;
    }

    @Override
    public boolean resolveType(KmlContext context) {
        if (this.expression == null) {
            return false;
        }
        if (!this.expression.resolveType(context)) {
            return false;
        }
        if (!this.typeCheckAgainst(this.expression, CostoBoolean.instance)) {
            context.getLogger().log(this + " must be Boolean ", this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
            return false;
        }
        return true;
    }
}

