/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlAssertionClause;
import costo.graph.KmlContext;
import costo.graph.Spec;
import costo.graph.Variable;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlPredicate;
import costo.graph.expressions.KmlSignature;
import costo.graph.types.CostoType;
import java.util.ArrayList;
import java.util.HashMap;

public class KmlFunction
extends KmlSignature {
    private ArrayList<Variable> functionParameters;
    private KmlAssertionClause pres;
    private KmlAssertionClause posts;

    public KmlFunction(String name, CostoType returnType) {
        super(name, returnType);
    }

    public void setFunctionParameters(ArrayList<Variable> parameters) {
        this.functionParameters = parameters;
        ArrayList<CostoType> types = new ArrayList<CostoType>();
        for (Variable var : parameters) {
            types.add(var.getCtype());
        }
        this.setParameters(types);
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Deprecated
    public void setFunctionParameters(HashMap<String, Variable> parameters) {
        this.functionParameters = (ArrayList)parameters.values();
        ArrayList<CostoType> types = new ArrayList<CostoType>();
        for (Variable var : parameters.values()) {
            types.add(var.getCtype());
        }
        this.setParameters(types);
    }

    @Override
    public String getRawValue() {
        return String.valueOf(this.getName()) + Spec.listToString(this.functionParameters, "(", ";", ")") + "\n" + (this.pres == null ? "" : Spec.mapToString(this.pres.getAssertMap(), "Pre\n", ":", ",", "\n")) + (this.posts == null ? "" : Spec.mapToString(this.posts.getAssertMap(), "Post\n", ":", ",", "\n"));
    }

    @Override
    public boolean resolveType(KmlContext context) {
        if (this.pres != null) {
            for (KmlPredicate pred : this.pres.getAssertMap().values()) {
                pred.resolveType(context);
            }
        }
        if (this.posts != null) {
            for (KmlPredicate pred : this.posts.getAssertMap().values()) {
                pred.resolveType(context);
            }
        }
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.pres != null) {
                for (KmlPredicate pred : this.pres.getAssertMap().values()) {
                    pred.accept(visitor);
                }
            }
            if (this.posts != null) {
                for (KmlPredicate pred : this.posts.getAssertMap().values()) {
                    pred.accept(visitor);
                }
            }
        }
    }

    public KmlAssertionClause getPres() {
        return this.pres;
    }

    public void setPres(KmlAssertionClause pres) {
        this.pres = pres;
    }

    public KmlAssertionClause getPosts() {
        return this.posts;
    }

    public void setPosts(KmlAssertionClause posts) {
        this.posts = posts;
    }
}

