/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.Spec;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlFunctionUseExpression;
import costo.graph.expressions.KmlSignature;
import costo.graph.types.CostoType;
import java.util.ArrayList;
import java.util.Iterator;

public class KmlFunctionCall
extends KmlFunctionUseExpression {
    protected KmlExpression target;
    protected String functionName;
    protected ArrayList<KmlExpression> operands;

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public KmlExpression getTarget() {
        return this.target;
    }

    public void setTarget(KmlExpression target) {
        this.target = target;
    }

    public KmlFunctionCall() {
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public KmlExpression deepCopy() {
        ArrayList<KmlExpression> twinops = null;
        if (this.operands != null) {
            twinops = new ArrayList<KmlExpression>();
            for (KmlExpression kmlExpression : this.operands) {
                twinops.add(kmlExpression.deepCopy());
            }
        }
        KmlFunctionCall twin = new KmlFunctionCall(this.target.deepCopy(), twinops);
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        twin.setLine(this.getLine());
        twin.setColumn(this.getColumn());
        twin.functionName = this.functionName;
        twin.function = this.function;
        return twin;
    }

    public KmlFunctionCall(KmlExpression target, ArrayList<KmlExpression> operands) {
        this.target = target;
        this.setColumn(target.getColumn());
        this.setLine(target.getLine());
        this.functionName = target.getRawValue();
        this.operands = operands;
        String rvalue = String.valueOf(this.functionName) + Spec.listToString(operands, "(", ",", ")");
        this.setRawValue(rvalue);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public KmlExpression getParameter(int index) {
        return this.operands.get(index);
    }

    public boolean hasParameters() {
        return !this.operands.isEmpty();
    }

    public Iterator<KmlExpression> iteratorOnParameters() {
        return this.operands.iterator();
    }

    public int numberOfParameters() {
        return this.operands.size();
    }

    public Object[] parametersToArray() {
        return this.operands.toArray();
    }

    @Override
    public String getRawValue() {
        return String.valueOf(this.functionName) + Spec.listToString(this.operands, "(", ",", ")");
    }

    @Override
    public boolean resolveType(KmlContext context) {
        boolean ok = true;
        ArrayList<CostoType> operandsTypes = null;
        if (this.operands != null) {
            operandsTypes = new ArrayList<CostoType>();
            for (KmlExpression operand : this.operands) {
                boolean newok = operand.resolveType(context);
                ok = ok && newok;
                operandsTypes.add(operand.getType());
            }
        }
        this.function = context.resolveFunction(this.functionName, operandsTypes, this);
        if (this.function == null) {
            return false;
        }
        this.function.setOp(false);
        this.type = this.function.getType();
        return ok;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            this.target.accept(visitor);
            if (this.operands != null) {
                for (KmlExpression operand : this.operands) {
                    operand.accept(visitor);
                }
            }
        }
    }

    public void setOperands(ArrayList<KmlExpression> operands) {
        this.operands = operands;
    }

    @Override
    public void setFunction(KmlSignature function) {
        super.setFunction(function);
        this.functionName = function.getName();
    }

    @Override
    public ArrayList<KmlExpression> getOperands() {
        return this.operands;
    }
}

