/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.Spec;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.KmlTypedStuff;
import costo.graph.types.CostoType;
import costo.graph.types.CostoVoid;
import costo.graph.types.SameType;
import java.util.ArrayList;

public class KmlSignature
extends KmlTypedStuff {
    private boolean isGeneric = false;
    private boolean isOp = false;
    private CostoType currentGenericReturn = null;
    private KmlSignature genericPrototype = null;
    private String name;
    private ArrayList<CostoType> parameters;
    private String declarSite = "";

    public KmlSignature(String name, ArrayList<CostoType> theparameters, CostoType returnType) {
        this.name = name;
        this.checkGenericity(theparameters);
        this.type = returnType;
    }

    public KmlSignature(String name, ArrayList<CostoType> theparameters, CostoType returnType, boolean isop) {
        this.name = name;
        this.checkGenericity(theparameters);
        this.type = returnType;
        this.isOp = isop;
    }

    public KmlSignature(String name, CostoType returnType) {
        this(name, null, returnType);
    }

    protected void checkGenericity(ArrayList<CostoType> theparameters) {
        this.isGeneric = false;
        if (theparameters != null && theparameters.size() > 0) {
            this.parameters = theparameters;
            if (this.parameters.contains(SameType.instance)) {
                this.isGeneric = true;
            }
        }
    }

    public KmlSignature getSignatureWithCurrentTypes() {
        CostoType returntype = this.type.instanciatedWithType(SameType.instance.getLastType());
        ArrayList<CostoType> instanciatedParameters = new ArrayList<CostoType>();
        if (this.parameters != null) {
            for (CostoType costoType : this.parameters) {
                instanciatedParameters.add(costoType.instanciatedWithType(SameType.instance.getLastType()));
            }
        }
        KmlSignature sig = new KmlSignature(this.name, instanciatedParameters, returntype);
        sig.genericPrototype = this;
        return sig;
    }

    public KmlSignature() {
    }

    public KmlSignature(CostoType type, String rawvalue) {
        super(type, rawvalue);
    }

    public boolean canBeCalledWithTypes(ArrayList<CostoType> actualParameterTypes) {
        if (actualParameterTypes == null && this.parameters == null) {
            return true;
        }
        if (actualParameterTypes == null) {
            return this.parameters.get(0) == CostoVoid.instance;
        }
        if (this.parameters == null) {
            return actualParameterTypes.get(0) == CostoVoid.instance;
        }
        if (actualParameterTypes.size() != this.parameters.size()) {
            return false;
        }
        int i = 0;
        while (i < this.parameters.size()) {
            if (this.parameters.get(i) == null || actualParameterTypes.get(i) == null || !actualParameterTypes.get(i).conformsTo(this.parameters.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Deprecated
    public KmlSignature(String name, String line, KmlContext context) {
        int arrowindex = line.indexOf("->");
        String parameterTypes = line.substring(0, arrowindex).trim();
        String returnType = line.substring(arrowindex + 2).trim();
        if (parameterTypes.length() > 0) {
            String[] types;
            this.parameters = new ArrayList();
            String[] stringArray = types = parameterTypes.split(";");
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type2 = stringArray[n2];
                this.parameters.add(context.resolveType(type2.trim()));
                ++n2;
            }
        }
        this.type = context.resolveType(returnType.trim());
        this.name = name;
    }

    @Deprecated
    public static void addKmlSignatures(String line, ArrayList<KmlSignature> list, KmlContext library) {
        int colonindex = line.indexOf(":");
        String[] names = line.substring(0, colonindex).trim().split(",");
        String rest = line.substring(colonindex + 1);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name2 = stringArray[n2];
            list.add(new KmlSignature(name2, rest, library));
            ++n2;
        }
    }

    public CostoType getReturnType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<CostoType> getParameters() {
        return this.parameters;
    }

    public void setParameters(ArrayList<CostoType> parameters) {
        this.parameters = parameters;
        this.checkGenericity(parameters);
    }

    @Override
    public String getRawValue() {
        return String.valueOf(this.name) + Spec.listToString(this.parameters, "(", ";", ")") + ":" + (this.type != null && !this.type.equals(CostoVoid.instance) ? this.type : "");
    }

    public CostoType getCurrentGenericReturn() {
        return this.currentGenericReturn;
    }

    public void setCurrentGenericReturn(CostoType currentGenericReturn) {
        this.currentGenericReturn = currentGenericReturn;
    }

    public boolean equalsIgnoreName(KmlSignature other) {
        if (other == null) {
            return false;
        }
        if (this.parameters == null && other.parameters == null) {
            return this.type == other.type;
        }
        if (this.parameters == null || other.parameters == null) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        return this.parameters.containsAll(other.parameters) && other.parameters.containsAll(this.parameters);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KmlSignature) {
            KmlSignature other = (KmlSignature)obj;
            return this.name.equals(other.getName()) && this.equalsIgnoreName(other);
        }
        return false;
    }

    public boolean isGeneric() {
        return this.isGeneric;
    }

    public void setGeneric(boolean isGeneric) {
        this.isGeneric = isGeneric;
    }

    public KmlSignature getGenericPrototype() {
        return this.genericPrototype;
    }

    public void setGenericPrototype(KmlSignature genericPrototype) {
        this.genericPrototype = genericPrototype;
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean isOp() {
        return this.isOp;
    }

    public void setOp(boolean isOp) {
        this.isOp = isOp;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("KmlSignature [name=");
        builder.append(this.name);
        builder.append(", parameters=");
        builder.append(this.parameters);
        builder.append(", getReturnType()=");
        builder.append(this.getReturnType());
        builder.append("]");
        return builder.toString();
    }

    public String getDeclarSite() {
        return this.declarSite;
    }

    public void setDeclarSite(String declarSite) {
        this.declarSite = declarSite;
    }
}

