/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.Localizable;
import costo.graph.types.CostoType;

public class KmlTypedStuff
implements Localizable {
    protected String rawValue;
    protected CostoType type;
    protected int line;
    protected int column;

    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public KmlTypedStuff(String rawvalue) {
        this.rawValue = rawvalue;
    }

    public KmlTypedStuff() {
    }

    public boolean resolveType(KmlContext context) {
        return false;
    }

    public String toString() {
        return this.getRawValue();
    }

    public KmlTypedStuff(CostoType type, String rawvalue) {
        this.type = type;
        this.rawValue = rawvalue;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public void setRawValue(String rawvalue) {
        this.rawValue = rawvalue;
    }

    public CostoType getType() {
        return this.type;
    }

    public void setType(CostoType type) {
        this.type = type;
    }

    public static boolean typeCheck(KmlTypedStuff subexpr, CostoType expected) {
        return KmlTypedStuff.typeCheck(subexpr, expected, "");
    }

    public static boolean typeCheck(KmlTypedStuff subexpr, CostoType expected, String additionalinfo) {
        if (subexpr.getType() == null) {
            return false;
        }
        return subexpr.getType().conformsTo(expected);
    }

    protected boolean typeCheckAgainst(KmlTypedStuff subexpr, CostoType expected) {
        return KmlTypedStuff.typeCheck(subexpr, expected, "Type Error " + this.getPositionAsText() + "in expression " + this.getRawValue() + " --> ");
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public void setColumn(int column) {
        this.column = column;
    }

    public KmlExpression deepCopy() {
        KmlExpression twin = new KmlExpression(this.type, this.rawValue);
        twin.setLine(this.line);
        twin.setColumn(this.column);
        return twin;
    }

    @Override
    public String getPositionAsText() {
        return "line: " + this.line + " column: " + this.column;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KmlTypedStuff)) {
            return false;
        }
        KmlTypedStuff other = (KmlTypedStuff)obj;
        return this.getRawValue().equals(other.getRawValue());
    }
}

