/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.Service;
import costo.graph.Spec;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlIdentifier;
import costo.graph.types.CostoBoolean;
import costo.graph.types.CostoType;
import java.util.ArrayList;

public class KmlUnchangedExpression
extends KmlExpression {
    private ArrayList<KmlIdentifier> variables = new ArrayList();

    public KmlUnchangedExpression(ArrayList<KmlIdentifier> variables) {
        this.variables = variables;
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean resolveType(KmlContext context) {
        boolean ok = true;
        for (KmlIdentifier var : this.variables) {
            ok &= var.resolveType(context);
            try {
                ((Service)context).addUnchangedVar(var.getVar());
            }
            catch (Exception exception) {}
        }
        return ok;
    }

    @Override
    public String getRawValue() {
        return Spec.listToString(this.variables, "Unchanged{", ",", "}");
    }

    @Override
    public CostoType getType() {
        return CostoBoolean.instance;
    }

    public ArrayList<KmlIdentifier> getVariables() {
        return this.variables;
    }

    @Override
    public KmlExpression deepCopy() {
        ArrayList<KmlIdentifier> twinvariables = new ArrayList<KmlIdentifier>();
        for (KmlIdentifier id : this.variables) {
            twinvariables.add((KmlIdentifier)id.deepCopy());
        }
        KmlUnchangedExpression twin = new KmlUnchangedExpression(twinvariables);
        return twin;
    }
}

