/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.visitors;

import costo.graph.KmlContext;
import costo.graph.Variable;
import costo.graph.expressions.AbstractExpressionVisitor;
import costo.graph.expressions.KmlArrayExpression;
import costo.graph.expressions.KmlAssignmentExpression;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlIdentifier;
import costo.graph.expressions.KmlTypedStuff;
import costo.graph.visitors.VariableUsage;
import java.util.HashMap;
import java.util.HashSet;

public class VariableUsageExpressionVisitor
extends AbstractExpressionVisitor {
    private KmlContext context;
    VariableUsage varUsage = new VariableUsage(new HashSet<Variable>(), new HashSet<Variable>());

    public VariableUsageExpressionVisitor() {
    }

    public VariableUsageExpressionVisitor(KmlContext context) {
        this.context = context;
    }

    public VariableUsageExpressionVisitor(VariableUsage varUsage) {
        this.varUsage = varUsage;
    }

    @Override
    public void defaultExpressionOperation(KmlTypedStuff expr) {
    }

    public KmlContext getContext() {
        return this.context;
    }

    public VariableUsage getVarUsage() {
        return this.varUsage;
    }

    public void setContext(KmlContext context) {
        this.context = context;
    }

    public void setVarUsage(VariableUsage varUsage) {
        this.varUsage = varUsage;
    }

    @Override
    public boolean visit(KmlAssignmentExpression expression) {
        KmlExpression left = expression.getLeftOperand();
        expression.getRightOperand().accept(this);
        Variable leftVar = null;
        if (left instanceof KmlArrayExpression) {
            left = ((KmlArrayExpression)left).getLeftPart();
        }
        if (left instanceof KmlIdentifier) {
            leftVar = ((KmlIdentifier)left).getVar();
        }
        if (leftVar != null) {
            this.varUsage.getModifiedVarlist().add(leftVar);
            this.varUsage.addDependencies(leftVar, this.getVarUsage().getReadVarlist());
        }
        return false;
    }

    @Override
    public boolean visit(KmlCommunication expression) {
        VariableUsageExpressionVisitor varVisit = new VariableUsageExpressionVisitor();
        if (expression.getActionType() == 8 || expression.getActionType() == 4) {
            if (expression.getParameters() != null) {
                for (KmlExpression param : expression.getParameters()) {
                    param.accept(varVisit);
                }
            }
            this.varUsage.getModifiedVarlist().addAll(varVisit.varUsage.getReadVarlist());
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(KmlIdentifier expression) {
        this.varUsage.getReadVarlist().add(expression.getVar());
        return super.visit(expression);
    }

    public HashMap<Variable, HashSet<Variable>> getDependencies() {
        return this.varUsage.getDependencies();
    }
}

