/*
 * Decompiled with CFR 0.152.
 */
package costo.utils.exports;

import costo.graph.LTS;
import costo.utils.exports.EPSUtils;
import costo.utils.exports.LTStoDot;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class LTStoEPS {
    public static void LayoutDotFile(String filename, String format, Properties props) {
        if (props == null) {
            try {
                LTStoEPS.LayoutDotFile(filename, format);
                System.err.println("NULL PROPERTIES");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            String archi = props.getProperty("costo.archi");
            String dotPP = props.getProperty(String.valueOf(archi) + ".dot.command");
            if (dotPP == null) {
                dotPP = props.getProperty("dotPathPreference");
            }
            LTStoEPS.LayoutDotFile(filename, format, dotPP);
        }
    }

    public static void LayoutDotFile(String filename, String format, String dotlayoutprogram) {
        if (dotlayoutprogram == null) {
            return;
        }
        String extension = format;
        if (format == "ps") {
            extension = "ps";
        } else if (format.equals("ps1")) {
            format = "ps";
            extension = "eps";
        } else if (format.equals("ps2")) {
            extension = "eps";
        } else if (format.equals("png")) {
            extension = "png";
        } else if (format.equals("svg")) {
            extension = "svg";
        } else if (format.equals("")) {
            extension = "dot";
        }
        String param = "";
        if (!format.equals("")) {
            param = " -T" + format + " ";
        }
        String dotcommand = String.valueOf(dotlayoutprogram) + " " + filename + ".dot" + param + " -o " + filename + "." + extension;
        try {
            System.out.print(">>" + extension + ">>> " + dotcommand + "...");
            Runtime.getRuntime().exec(dotcommand);
            if (extension == "eps") {
                Point size = EPSUtils.getBoundingBox(String.valueOf(filename) + ".eps");
                if (size.getX() == 0.0 && size.getY() == 0.0) {
                    System.err.println("corrupted bounding box: " + filename + ".eps");
                } else {
                    String epsToPdfcommand = "ps2pdf " + filename + ".eps " + filename + ".pdf";
                    System.out.print("\n>>PDF>>> " + epsToPdfcommand + "...");
                    Runtime.getRuntime().exec(epsToPdfcommand);
                }
            }
            System.out.println(" done");
        }
        catch (IOException iOException) {
            System.err.println(">>>>> " + dotcommand + " failed\n please generate manually the " + format + " file with graphviz \n for file " + filename);
        }
    }

    public static void LayoutDotFile(String filename, String format) throws FileNotFoundException, IOException {
        Properties userprop = new Properties();
        userprop.load(new FileInputStream("Kml2latex.userprefs"));
        String dotlayoutprogram = userprop.getProperty("costo.dot.command");
        if (dotlayoutprogram == null) {
            dotlayoutprogram = "/usr/bin/dot";
        }
        LTStoEPS.LayoutDotFile(filename, format, dotlayoutprogram);
    }

    public static void write(LTS lts, String outputpath, String filename, Properties p) throws IOException {
        File rep;
        if (lts == null) {
            return;
        }
        if (outputpath == null) {
            outputpath = System.getProperty("user.dir");
            System.out.println("default Dot output dir " + outputpath);
        }
        if (!(rep = new File(outputpath)).exists()) {
            rep.mkdir();
        }
        LTStoDot.write(lts, String.valueOf(outputpath) + filename + ".dot");
        LTStoEPS.LayoutDotFile("\"" + outputpath + filename + "\"", "svg", p);
        LTStoEPS.LayoutDotFile("\"" + outputpath + filename + "\"", "png", p);
        LTStoEPS.LayoutDotFile("\"" + outputpath + filename + "\"", "ps1", p);
    }

    public static void write(LTS lts, String outputpath, String filename) throws IOException {
        if (lts == null) {
            return;
        }
        if (outputpath != null) {
            File rep = new File(outputpath);
            if (!rep.exists()) {
                rep.mkdir();
            }
            LTStoDot.write(lts, String.valueOf(outputpath) + filename + ".dot");
            LTStoEPS.LayoutDotFile("\"" + outputpath + filename + "\"", "svg");
            LTStoEPS.LayoutDotFile("\"" + outputpath + filename + "\"", "ps1");
        }
    }

    public static void main(String[] args) {
        System.out.println("I do nothing, see costo.checks.debug.GrammarTest or KMLtoTEX");
    }
}

