/*
 * Decompiled with CFR 0.152.
 */
package costolib.ui.utils;

import costo.graph.Component;
import costo.graph.Service;
import costolib.ui.utils.ComponentLoader;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class PopupActionOnComponent
implements IObjectActionDelegate {
    private Shell shell;
    private IFile selectedFile;
    private Component selectedComponent;

    public Service selectServiceFromGUI(int criterion) {
        if (this.selectedComponent == null) {
            return null;
        }
        Collection serv = this.selectedComponent.getServicesMeetingCriterion(criterion);
        if (serv == null || serv.isEmpty()) {
            return null;
        }
        Icon icon = null;
        ArrayList<String> servsigs = new ArrayList<String>();
        for (Service s : serv) {
            servsigs.add(s.getSignature());
        }
        Object[] services = servsigs.toArray();
        String servname = (String)JOptionPane.showInputDialog(null, "Select the service :", " ", -1, icon, services, services[0]);
        if (servname == null) {
            return null;
        }
        return this.selectedComponent.getService(servname);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public abstract void run(IAction var1);

    public final void selectionChanged(IAction action, ISelection selection) {
        Object singleselection;
        if (selection instanceof IStructuredSelection && (singleselection = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.selectedFile = (IFile)singleselection;
            this.selectedComponent = null;
        }
    }

    public final Shell getShell() {
        return this.shell;
    }

    public final IFile getSelectedFile() {
        return this.selectedFile;
    }

    public final Component getSelectedComponent() {
        if (this.selectedFile == null) {
            return null;
        }
        if (this.selectedComponent == null) {
            this.selectedComponent = ComponentLoader.getSingleton().getComponentFromFile(this.selectedFile);
        }
        return this.selectedComponent;
    }
}

