/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml_test.chaine;

import costo.graph.Component;
import costo.graph.ComponentVariable;
import costo.graph.Link;
import costo.graph.Service;
import costo.graph.ServiceIdentifier;
import costo.graph.Spec;
import costo.graph.Variable;
import costo.graph.expressions.KmlPredicate;
import costo.graph.types.CostoType;
import costo.graph.types.CostoVoid;
import costolib_plugin_kml_test.chaine.ITComponent;
import costolib_plugin_kml_test.chaine.TComponent;
import costolib_plugin_kml_test.chaine.THarness;
import costolib_plugin_kml_test.chaine.TService;
import costolib_plugin_kml_test.utils.JCheckPanel;
import costolib_plugin_kml_test.utils.TestIntentionControlPanel;
import costolib_plugin_kml_test.utils.TestPerimeterPanel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class TUtile {
    public static Component intention = null;
    public static TestIntentionControlPanel intentionPanel = null;
    public static TestPerimeterPanel perimeterPanel = null;
    public static List<ITComponent> tcomponents = new ArrayList<ITComponent>();
    public static TService sut = null;
    public static TComponent cut = null;
    public static THarness frame = null;
    public static Map<String, Variable> oracleVariables = null;
    public static List<Variable> inOutvarsUsed = new ArrayList<Variable>();
    public static List<Map<String, String>> assemblies = new ArrayList<Map<String, String>>();
    public static Map<String, TService> mocks = new HashMap<String, TService>();
    public static Map<String, TService> outputAssignments = new HashMap<String, TService>();

    public static Variable selectInputVariableToAssign(Variable target) {
        if (intention == null) {
            return null;
        }
        ArrayList<Variable> inputVars = new ArrayList<Variable>();
        for (Variable var : intention.getVariables().values()) {
            if (var == null || var.getType() == null || !var.getType().equalsIgnoreCase(target.getType())) continue;
            inputVars.add(var);
        }
        inputVars.add(new Variable("New Input Variable", target.getCtype(), true));
        inputVars.add(new Variable("unassigned", (CostoType)CostoVoid.instance, true));
        Object[] tablo = new Variable[inputVars.size()];
        tablo = inputVars.toArray(tablo);
        Variable var = (Variable)JOptionPane.showInputDialog(null, "Select the abstract variable to assign to " + target, "Assign to " + target, -1, null, tablo, tablo[0]);
        return var;
    }

    public static Variable selectInputVariableToAssign(Service target) {
        if (intention == null) {
            return null;
        }
        ArrayList<Variable> inputVars = new ArrayList<Variable>();
        for (Variable var : intention.getVariables().values()) {
            if (var == null || var.getType() == null || !var.getType().equalsIgnoreCase(target.getResultVar().getType())) continue;
            inputVars.add(var);
        }
        inputVars.add(new Variable("New Input Variable", target.getReturnCostoType(), true));
        inputVars.add(new Variable("unassigned", (CostoType)CostoVoid.instance, true));
        Object[] tablo = new Variable[inputVars.size()];
        tablo = inputVars.toArray(tablo);
        Variable var = (Variable)JOptionPane.showInputDialog(null, "Select the abstract variable to assign to " + target, "Assign to " + target, -1, null, tablo, tablo[0]);
        return var;
    }

    public static Variable selectOutputVariableToAssign(Variable target) {
        System.out.println("Tut targ typ:" + target.getType());
        if (intention == null) {
            return null;
        }
        ArrayList<Variable> outputVars = new ArrayList<Variable>();
        for (Variable var : intention.getConstants().values()) {
            if (var == null || var.getType() == null || !var.getType().equalsIgnoreCase(target.getType())) continue;
            outputVars.add(var);
        }
        outputVars.add(new Variable("New Output Variable", target.getCtype(), true));
        outputVars.add(new Variable("unassigned", (CostoType)CostoVoid.instance, true));
        Object[] tablo = new Variable[1];
        tablo = outputVars.toArray(tablo);
        Variable var = (Variable)JOptionPane.showInputDialog(null, "Select the abstract variable to assign to " + target, "Assign to " + target, -1, null, tablo, tablo[0]);
        return var;
    }

    public static ServiceIdentifier assignReq(ServiceIdentifier s, ServiceIdentifier lastSelect) {
        ArrayList<ServiceIdentifier> linknames = new ArrayList<ServiceIdentifier>();
        Link l = s.getLink();
        if (l != null) {
            linknames.add(l.getOther(s));
        }
        if (lastSelect == null || !lastSelect.getVarName().contains("Mock")) {
            CostoType returntype = s.getServ().getReturnCostoType();
            ServiceIdentifier mock = new ServiceIdentifier(String.valueOf(returntype.getName()) + "Mock" + Spec.getIndex(), String.valueOf(returntype.getName()) + "Mock", 0, 0);
            linknames.add(mock);
        } else {
            linknames.add(lastSelect);
        }
        ArrayList<JCheckPanel> complist = new ArrayList<JCheckPanel>();
        JCheckPanel selectLink = new JCheckPanel(linknames, lastSelect);
        complist.add(selectLink);
        JOptionPane.showMessageDialog(frame, complist.toArray(), "assign provided service", 3);
        ServiceIdentifier selected = null;
        if (selectLink.getSelected() != null && !selectLink.getSelected().isEmpty()) {
            selected = (ServiceIdentifier)selectLink.getSelected().get(0);
        }
        return selected;
    }

    public static ComponentVariable getCompVarFromServ(Service serv) {
        System.out.println(" getCompVarFromServ " + serv.getName());
        for (ITComponent tcomp : tcomponents) {
            if (!tcomp.getCompVar().getComponentType().getServicesMap().values().contains(serv)) continue;
            return tcomp.getCompVar();
        }
        System.out.println(" getCompVarFromServ " + serv.getName() + " not found");
        return null;
    }

    public static void init(THarness tHarness, Component intent, TestPerimeterPanel perim) {
        frame = tHarness;
        intention = intent;
        perimeterPanel = perim;
        tcomponents = new ArrayList<ITComponent>();
        cut = null;
        sut = null;
        TUtile.setVariablesInOracle();
    }

    public static void setVariablesInOracle() {
        oracleVariables = new HashMap<String, Variable>();
        for (Variable input : intentionPanel.getInputVarsAssignment().keySet()) {
            for (KmlPredicate pred : intention.getProperties().values()) {
                if (!pred.getRawValue().contains(input.getName())) continue;
                oracleVariables.put(input.getName(), input);
            }
        }
        for (Variable output : intentionPanel.getOutputVarsAssignment().keySet()) {
            for (KmlPredicate pred : intention.getProperties().values()) {
                if (!pred.getRawValue().contains(output.getName())) continue;
                oracleVariables.put(output.getName(), output);
            }
        }
    }

    public static void hideUnusedTab() {
        System.out.println(" hide called ");
        for (ITComponent tcomp : tcomponents) {
            if (!tcomp.isVisible() || tcomp.getProvided() != null && !tcomp.getProvided().isEmpty()) continue;
            tcomp.setVisible(false);
            System.out.println(String.valueOf(tcomp.getCompVar().getVarName()) + " has no provided");
            int i = 0;
            while (i < TUtile.frame.tabPanel.getTabCount()) {
                if (TUtile.frame.tabPanel.getTitleAt(i).equals(tcomp.getCompVar().getVarName())) {
                    System.out.println(" compo :" + TUtile.frame.tabPanel.getTitleAt(i) + " is deleted");
                    TUtile.frame.tabPanel.removeTabAt(i);
                }
                ++i;
            }
        }
    }

    public static void evaluateStateAssigments() {
        inOutvarsUsed = new ArrayList<Variable>();
        String systState = "";
        for (ITComponent tcomp : tcomponents) {
            if (!tcomp.isVisible()) continue;
            int totToAssign = tcomp.getTotalToAssign();
            int totAssigned = tcomp.getTotalAssigned();
            float state = 0.0f;
            if (totToAssign > 0) {
                state = 100 * totAssigned / totToAssign;
            }
            if (!systState.isEmpty()) {
                systState = String.valueOf(systState) + "\n";
            }
            systState = String.valueOf(systState) + tcomp.getCompVar().getVarName() + ": [" + state + " %]";
        }
        int nbOracleVars = oracleVariables.size();
        int nbOracleVarsAssigned = 0;
        for (Variable varOracle : oracleVariables.values()) {
            if (!inOutvarsUsed.contains(varOracle)) continue;
            ++nbOracleVarsAssigned;
        }
        float oracleState = 0.0f;
        if (nbOracleVars > 0) {
            oracleState = 100 * nbOracleVarsAssigned / nbOracleVars;
        }
        systState = "Oracles: [" + oracleState + " %] \n" + systState;
        TUtile.perimeterPanel.state.setText(systState);
    }

    public static void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
            }
            String[] stringArray = files = src.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                TUtile.copyFolder(srcFile, destFile);
                ++n2;
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }
}

