/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml_test.popup.actions;

import costo.graph.Component;
import costo.graph.CostoLibrary;
import costo.graph.KmlContext;
import costo.graph.Service;
import costo.graph.ServiceIdentifier;
import costo.graph.Spec;
import costo.graph.Variable;
import costo.graph.types.CostoType;
import costo.graph.types.CostoVoid;
import costo.graph.visitors.KmlElementVisitor;
import costo.graph.visitors.VariableUsage;
import costo.graph.visitors.VariableUsageComponentVisitor;
import costolib.ui.utils.PopupActionOnComponent;
import costolib_plugin_kml_test.Activator;
import costolib_plugin_kml_test.utils.JCheckPanel;
import costolib_plugin_kml_test.utils.JCompositeServSelector;
import costolib_plugin_kml_test.utils.JParamAssignmentPanel;
import costolib_plugin_kml_test.utils.JRequiredAssignmentPanel;
import costolib_plugin_kml_test.utils.NewTestHarnessCreatingProcessFrame;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;

public class HarnessModelMappingCreatorAction
extends PopupActionOnComponent {
    private ArrayList<Variable> params;
    private ArrayList<Variable> externaldata;
    private ArrayList<Variable> statevariabledata;
    private Map<Variable, Service> externaldatamappings;
    private Service selectedService;
    private ServiceIdentifier selectedServiceId;
    private SimpleHash testComp = new SimpleHash();
    private SimpleSequence vars = new SimpleSequence();
    private String tcompname;
    private ArrayList<Service> calledS = new ArrayList();
    private Map<String, Service> callableserviceInfoMap = new HashMap<String, Service>();
    private Map<String, Service> configserviceInfoMap = new HashMap<String, Service>();
    private Properties testconfig = new Properties();
    private String testlib = "PLATOONTESTLIB";
    private Component comp;

    public HarnessModelMappingCreatorAction() {
    }

    public HarnessModelMappingCreatorAction(Component comp) {
        this.comp = comp;
    }

    public void run(IAction action) {
        this.comp = this.getSelectedComponent();
        if (this.comp == null) {
            System.err.println("comp is null");
            return;
        }
        this.executeAction();
    }

    public void executeAction() {
        NewTestHarnessCreatingProcessFrame test = new NewTestHarnessCreatingProcessFrame(this.comp);
        test.pack();
        test.setVisible(true);
    }

    public void executeActionOLD() {
        this.selectedService = this.selectService(this.comp);
        if (this.selectedService == null) {
            System.out.println(" no service selected");
            return;
        }
        System.out.println(this.selectedService.getFullName());
        this.calledS.add(this.selectedService);
        this.tcompname = "TEST_" + this.selectedService.getName().toUpperCase();
        this.formalServiceDataSelection();
        this.assignConcreteEntryPoints();
        this.checkDependenciesAndAssignMissing();
        this.finalizeContextGeneration();
        this.generateTestComponent();
        this.refresh();
    }

    private void generateTestComponent() {
        Template testtmmpl = Activator.getDefault().getTestComponentTemplate();
        try {
            FileWriter out = new FileWriter(String.valueOf(this.getExportDir()) + File.separator + this.tcompname + ".kcp");
            testtmmpl.process((Object)this.testComp, (Writer)out);
            ((Writer)out).flush();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void finalizeContextGeneration() {
        SimpleSequence requiredsigs = new SimpleSequence();
        ArrayList<String> snames = new ArrayList<String>();
        HashSet<String> liblistnames = new HashSet<String>();
        for (Service s : this.calledS) {
            snames.add(s.getName());
            requiredsigs.add((Object)s.getSignature());
            for (CostoLibrary lib : s.getOwner().getLibraries()) {
                liblistnames.add(lib.getName());
            }
        }
        liblistnames.add(this.testlib);
        String sutcall = this.generateCall(this.selectedService);
        CostoType returnCostoType = this.selectedService.getReturnCostoType();
        if (returnCostoType != null && returnCostoType != CostoVoid.instance) {
            sutcall = "servresult:= " + sutcall;
        }
        this.testComp.put("tcname", (Object)this.tcompname);
        this.testComp.put("requirednamelist", (Object)Spec.listToString(snames, (String)"", (String)",", (String)""));
        this.testComp.put("liblist", (Object)Spec.listToString(liblistnames, (String)"", (String)",", (String)""));
        this.testComp.put("requiredsigs", (Object)requiredsigs);
        this.testComp.put("vars", (Object)this.vars);
        this.testComp.put("SUTcall", (Object)sutcall);
        this.testComp.put("SUTinitsequence", (Object)"//TODO");
        this.testComp.put("SUToracle", (Object)"//TODO");
    }

    private void checkDependenciesAndAssignMissing() {
        ArrayList dependencies = this.getSelectedComponent().dependencies(this.selectedService);
        System.out.println("Check remaining dependencies + ");
        for (Service s : dependencies) {
            System.out.println(s.getName());
        }
    }

    private void assignConcreteEntryPoints() {
        this.externaldata.isEmpty();
        if (!this.statevariabledata.isEmpty()) {
            JCheckPanel callablepanel;
            this.analyzeServices();
            ArrayList<JComponent> complist = new ArrayList<JComponent>();
            if (this.callableserviceInfoMap.isEmpty()) {
                complist.add(new JLabel("No direct modifier service found"));
            } else {
                ArrayList<String> orderedcallable = new ArrayList<String>(this.callableserviceInfoMap.keySet());
                callablepanel = new JCheckPanel(orderedcallable, true);
                complist.add(new JLabel("modifier services"));
                complist.add(callablepanel);
            }
            if (this.configserviceInfoMap.isEmpty()) {
                complist.add(new JLabel("No config service found"));
            } else {
                ArrayList<String> orderedconfig = new ArrayList<String>(this.configserviceInfoMap.keySet());
                callablepanel = new JCheckPanel(orderedconfig, true);
                complist.add(new JLabel("config services"));
                complist.add(callablepanel);
            }
            JOptionPane.showMessageDialog(null, complist.toArray(), "data binding: component state", 3);
            CostoType returnCostoType = this.selectedService.getReturnCostoType();
            if (returnCostoType != null && returnCostoType != CostoVoid.instance) {
                SimpleHash var = new SimpleHash();
                var.put("name", (Object)"servresult");
                var.put("type", (Object)returnCostoType.toString());
                this.vars.add((Object)var);
            }
        }
    }

    private void analyzeServices() {
        System.out.println("statevars: " + this.statevariabledata);
        for (Service serv : this.selectedService.getOwner().getServicesMeetingCriterion(1)) {
            VariableUsageComponentVisitor visitor = new VariableUsageComponentVisitor((KmlContext)this.selectedService);
            serv.accept((KmlElementVisitor)visitor);
            VariableUsage varusage = visitor.getVariableUsage();
            new ArrayList<Variable>(this.statevariabledata);
            HashSet writeVarlist = new HashSet(varusage.getModifiedVarlist());
            writeVarlist.retainAll(this.statevariabledata);
            if (writeVarlist.isEmpty()) continue;
            String info = serv.getSignature() + "\n modified vars: " + writeVarlist + "\n";
            info = String.valueOf(info) + "\n dependencies" + serv.getInterface().getExtrequired();
            if (serv.getPostClause() != null) {
                info = String.valueOf(info) + "\n post " + serv.getPostClause().toString();
            }
            if (serv.getOwner().getInterface().getConfig().contains(serv.getName())) {
                this.configserviceInfoMap.put(info, serv);
            }
            if (!serv.getOwner().getInterface().getProvided().contains(serv.getName())) continue;
            this.callableserviceInfoMap.put(info, serv);
        }
    }

    private Service selectService(Component comp) {
        JCompositeServSelector selector = new JCompositeServSelector(comp);
        ArrayList<JCompositeServSelector> complist = new ArrayList<JCompositeServSelector>();
        complist.add(selector);
        JOptionPane.showMessageDialog(null, complist.toArray(), "select target service", 3);
        this.selectedServiceId = selector.getSelected().get(0);
        return this.selectedServiceId.getServ();
    }

    private void formalServiceDataSelection() {
        if (this.selectedService == null) {
            return;
        }
        ArrayList<JPanel> complist = new ArrayList<JPanel>();
        this.params = this.selectedService.getParameters();
        if (this.params != null && !this.params.isEmpty()) {
            JParamAssignmentPanel paramAssignPanel = new JParamAssignmentPanel(this.selectedService);
            complist.add(paramAssignPanel);
        }
        this.selectedService.accept((KmlElementVisitor)new VariableUsageComponentVisitor((KmlContext)this.selectedService));
        VariableUsage varusage = (VariableUsage)this.selectedService.getProperty("variablevisit");
        ArrayList<Variable> compvars = new ArrayList<Variable>();
        HashSet readVarlist = varusage.getReadVarlist();
        if (readVarlist != null) {
            for (Variable v : readVarlist) {
                if (v == null || v.getDeclarationContext() == null || !v.getDeclarationContext().equals(this.selectedService.getOwner())) continue;
                compvars.add(v);
            }
        }
        ArrayList<Variable> extdata = new ArrayList<Variable>();
        ArrayList required = this.selectedService.getRequired();
        if (required != null) {
            for (Service s : required) {
                CostoType returnCType = s.getReturnCostoType();
                if (returnCType == null || returnCType == CostoVoid.instance) continue;
                extdata.add(new Variable(s.getName(), returnCType));
            }
        }
        JCheckPanel compvarspanel = new JCheckPanel(compvars, true);
        if (compvars != null && !compvars.isEmpty()) {
            compvarspanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Component State"));
            complist.add(compvarspanel);
        }
        JRequiredAssignmentPanel requiredAssignment = new JRequiredAssignmentPanel(this.getSelectedServiceId());
        complist.add(requiredAssignment);
        JOptionPane.showMessageDialog(null, complist.toArray(), "select relevant formal service data", 3);
        this.statevariabledata = compvarspanel.getSelected();
        System.out.println(this.getExportDir());
    }

    private ServiceIdentifier getSelectedServiceId() {
        return this.selectedServiceId;
    }

    private String getExportDir() {
        String temp = this.getSelectedComponent().getFilePath();
        temp = temp.substring(0, temp.lastIndexOf(File.separator));
        return temp;
    }

    private void saveMapping() {
    }

    private String generateCall(Service selectedService) {
        String servcall = "!!" + selectedService.getName() + "(";
        Iterator varit = selectedService.getParameters().iterator();
        while (varit.hasNext()) {
            servcall = String.valueOf(servcall) + " getData(\"" + ((Variable)varit.next()).getName() + "\")";
            if (!varit.hasNext()) continue;
            servcall = String.valueOf(servcall) + ", ";
        }
        servcall = String.valueOf(servcall) + ")";
        return servcall;
    }

    private void refresh() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.getRoot();
        IProject wSDLFile = this.getSelectedFile().getProject();
        System.out.println("file" + wSDLFile);
        if (wSDLFile != null) {
            try {
                wSDLFile.refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

