/*
 * Decompiled with CFR 0.152.
 */
package costolib_plugin_kml2java;

import costo.graph.Component;
import costo.graph.KmlElement;
import costo.graph.Spec;
import costo.graph.expressions.KmlSignature;
import costo.graph.visitors.KmlElementVisitor;
import costo.kml2java.export.ComponentJavaContextCreatorVisitor;
import costo.kml2java.export.ComponentToJava;
import costo.kml2java.export.OperatorReplacement;
import costolib.ui.interfaces.IComponentActor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class Kml2JavaComponentActor1
implements IComponentActor {
    private boolean contextCheckMode = false;
    private Map<String, ArrayList<KmlSignature>> missingMappings;
    private String exportPackage = "";
    private String sourceDir = "";

    public Kml2JavaComponentActor1(boolean contextCheckMode) {
        this.contextCheckMode = contextCheckMode;
    }

    public Kml2JavaComponentActor1() {
    }

    public void doSomethingWithComponent(Component comp, KmlElement currentSelection, String relativePath) {
        ComponentJavaContextCreatorVisitor visitor = new ComponentJavaContextCreatorVisitor();
        String compPath = comp.getFilePath();
        compPath = compPath.replace("\\", "/");
        relativePath = relativePath.replace("\\", "/");
        String projectroot = compPath.substring(0, compPath.indexOf(relativePath));
        String srcdir = String.valueOf(projectroot) + File.separator + "src";
        this.setSourceDir(projectroot);
        int lastdot = relativePath.lastIndexOf(".");
        String exportdirRelPath = relativePath.substring(0, lastdot);
        String cleanedRelPath = exportdirRelPath.replaceAll("/", "\u00c3\u00b9").replaceAll("[^\\p{Alnum}.\u00c3\u00b9]", "");
        String exportingPath = String.valueOf(projectroot) + "src" + "/" + cleanedRelPath.replaceAll("\u00c3\u00b9", "/");
        String startingpackage = cleanedRelPath.replaceAll("\u00c3\u00b9", ".");
        visitor.setStarting_package(startingpackage);
        this.setExportPackage(startingpackage);
        visitor.setOpmap(this.getOpMap(projectroot, compPath));
        comp.accept((KmlElementVisitor)visitor);
        this.missingMappings = visitor.getMissingmappings();
        if (this.contextCheckMode) {
            return;
        }
        if (!visitor.getMissingmappings().isEmpty()) {
            String message = "Missing mappings\n" + Spec.maplistToString(visitor.getMissingmappings(), (String)"in ", (String)"\n", (String)"\n in ", (String)"\n Do you want to add them now ? ", (String)"   ", (String)"\n   ", (String)"\n");
            JOptionPane.showConfirmDialog(null, message);
        }
        ComponentToJava producer = new ComponentToJava(comp);
        producer.setCurrentDir(exportingPath);
        producer.setSrcdir(srcdir);
        producer.exportComponent(visitor);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IResource wSDLFile = workspaceRoot.findMember(new Path(projectroot).lastSegment());
        if (wSDLFile != null) {
            try {
                wSDLFile.refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private HashMap<String, OperatorReplacement> getOpMap(String projectroot, String compPath) {
        HashMap<String, OperatorReplacement> map = new HashMap<String, OperatorReplacement>();
        return map;
    }

    public boolean isApplicableFor(KmlElement currentSelection) {
        return false;
    }

    public boolean isContextCheckMode() {
        return this.contextCheckMode;
    }

    public void setContextCheckMode(boolean contextCheckMode) {
        this.contextCheckMode = contextCheckMode;
    }

    public Map<String, ArrayList<KmlSignature>> getMissingMappings() {
        return this.missingMappings;
    }

    public void setExportPackage(String exportPackage) {
        this.exportPackage = exportPackage;
    }

    public String getExportPackage() {
        return this.exportPackage;
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }
}

