/*
 * Decompiled with CFR 0.152.
 */
package costo.checks.debug;

import costo.graph.Component;
import costo.graph.ComponentFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class GrammarTest {
    private static boolean verbose = false;

    private static void output(String line) {
        if (!verbose) {
            return;
        }
        System.out.println(line);
    }

    private static void outputd(String line) {
        System.out.println(line);
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        File directory = new File("spec/kmelia/");
        if (!directory.isDirectory()) {
            GrammarTest.output(String.valueOf(directory.getName()) + " is not a directory");
        }
        GrammarTest.listContents(directory, "");
    }

    static void listContents(File dir, String indent) {
        String[] files;
        indent = String.valueOf(indent) + " ";
        String[] stringArray = files = dir.list();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            File f = new File(String.valueOf(dir.getAbsolutePath()) + "/" + file);
            if (f.isDirectory()) {
                GrammarTest.listContents(f, indent);
            } else if (file.endsWith(".cmp")) {
                GrammarTest.outputd("\n" + indent + "found component " + dir.getAbsolutePath() + "/" + file);
                GrammarTest.doTestCmpFile(String.valueOf(dir.getAbsolutePath()) + "/", file);
            }
            ++n2;
        }
    }

    private static void doTestCmpFile(String abspath, String filename) {
        String compname = String.valueOf(abspath) + filename;
        try {
            new FileReader(compname);
            ComponentFactory cf = new ComponentFactory();
            cf.init();
            cf.setAbsSpecDir(abspath);
            Component thecomp = cf.getComponent(compname);
            thecomp.getName();
            System.out.println(thecomp.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void doSomethingWithCmpFile(String abspath, String filename) {
        try {
            ComponentFactory cf = new ComponentFactory();
            cf.init();
            cf.setAbsSpecDir(abspath);
            Component test = cf.getComponent(filename);
            GrammarTest.output(test.toString());
            test.flattenAllLTS();
            GrammarTest.output("#############################################");
            GrammarTest.output("#############################################");
            GrammarTest.output("#############################################");
            GrammarTest.output(test.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

