/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.KmlStructuralElement;
import costo.graph.Spec;
import java.util.ArrayList;
import java.util.HashMap;

public class ComponentInterface
extends KmlStructuralElement {
    private ArrayList<String> provided;
    private ArrayList<String> required;
    private ArrayList<String> config;
    private ArrayList<String> autorun;

    public ComponentInterface() {
        this.provided = new ArrayList();
        this.required = new ArrayList();
        this.config = new ArrayList();
        this.autorun = new ArrayList();
    }

    public ComponentInterface(HashMap<String, ArrayList<String>> map) {
        this.provided = map.get("provides");
        this.required = map.get("requires");
        this.config = map.get("config");
        this.autorun = map.get("autorun");
    }

    public String toString() {
        String s = "INTERFACE\n";
        s = this.provided != null && !this.provided.isEmpty() ? String.valueOf(s) + "  provides : " + Spec.listToString(this.provided, "{", ", ", "}") + "\n" : String.valueOf(s) + "  #provides: {}\n";
        s = this.required != null && !this.required.isEmpty() ? String.valueOf(s) + "  requires : " + Spec.listToString(this.required, "{", ", ", "}") + "\n" : String.valueOf(s) + "  #requires: {}\n";
        s = this.config != null && !this.config.isEmpty() ? String.valueOf(s) + "  config : " + Spec.listToString(this.config, "{", ", ", "}") + "\n" : String.valueOf(s) + "  #config: {}\n";
        s = this.autorun != null && !this.autorun.isEmpty() ? String.valueOf(s) + "  autorun : " + Spec.listToString(this.autorun, "{", ", ", "}") + "\n" : String.valueOf(s) + "  #autorun: {}\n";
        return s;
    }

    public ComponentInterface(ArrayList<String> provided, ArrayList<String> required) {
        this.provided = provided;
        this.required = required;
    }

    public void setRequired(ArrayList<String> required) {
        this.required = required;
    }

    public ArrayList<String> getRequired() {
        return this.required;
    }

    public void setProvided(ArrayList<String> provided) {
        this.provided = provided;
    }

    public ArrayList<String> getProvided() {
        return this.provided;
    }

    public String toStringXML() {
        String s = "<INTERFACE>\n";
        if (this.provided != null) {
            s = String.valueOf(s) + Spec.listToString(this.provided, "<provided><servicename=\"", "\"/>\n<servicename=\" ", "\"/>\n</provided>") + "\n";
        }
        if (this.required != null) {
            s = String.valueOf(s) + Spec.listToString(this.required, "<required><servicename=\"", "\"/>\n<servicename=\" ", "\"/>\n</provided>") + "\n";
        }
        return String.valueOf(s) + "</INTERFACE>\n";
    }

    public boolean isDirectlyAccessible(String name) {
        if (this.provided.contains(name)) {
            return true;
        }
        return this.required.contains(name);
    }

    public ArrayList<String> getConfig() {
        return this.config;
    }

    public void setConfig(ArrayList<String> config) {
        this.config = config;
    }

    public ArrayList<String> getAutorun() {
        return this.autorun;
    }

    public void setAutorun(ArrayList<String> autorun) {
        this.autorun = autorun;
    }

    public ComponentInterface shallowCopy() {
        ComponentInterface copy = new ComponentInterface();
        copy.provided = (ArrayList)this.getProvided().clone();
        copy.required = (ArrayList)this.getRequired().clone();
        copy.config = (ArrayList)this.getConfig().clone();
        copy.autorun = (ArrayList)this.getAutorun().clone();
        return copy;
    }
}

