/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.Assembly;
import costo.graph.Component;
import costo.graph.ComponentVariable;
import costo.graph.KmlStructuralElement;
import costo.graph.Link;
import costo.graph.Spec;
import costo.graph.visitors.KmlElementVisitor;
import java.util.ArrayList;
import java.util.HashMap;

public class Composition
extends KmlStructuralElement {
    private String comment = "";
    private Component owner;
    private Assembly assembly;
    private HashMap<String, Link> promotionLinks;

    public Assembly getAssembly() {
        return this.assembly;
    }

    public void setAssembly(Assembly assembly) {
        this.assembly = assembly;
    }

    public void setPromotionLinks(HashMap<String, Link> promotionLinks) {
        this.promotionLinks = promotionLinks;
    }

    public Component getOwner() {
        return this.owner;
    }

    public void setOwner(Component owner) {
        this.owner = owner;
        if (this.assembly != null) {
            this.assembly.setOwner(owner);
        }
    }

    public String toString() {
        String indent = "   ";
        String s = "COMPOSITION\n    #" + this.comment + "\n";
        s = String.valueOf(s) + this.assembly.toString(indent);
        s = String.valueOf(s) + Spec.mapToString(this.promotionLinks, "Promotions", "", "\n" + indent, "");
        s = String.valueOf(s) + "END_COMPOSITION\n";
        return s;
    }

    public void structureCompletion() {
        ComponentVariable enclosingComponentRef = new ComponentVariable("SELF", this.getOwner().getName(), 0, 0);
        enclosingComponentRef.setComponentType(this.getOwner());
        this.assembly.getNamedComponents().add(enclosingComponentRef);
        this.assembly.setFilePath(this.owner.getFilePath());
        this.assembly.structureCompletion();
        this.assembly.resolveLinks();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public void accept(KmlElementVisitor visitor) {
        if (visitor.visit(this)) {
            this.assembly.accept(visitor);
        }
    }

    public ArrayList<ComponentVariable> getAssemblyNamedComponents() {
        return this.assembly.getAssemblyNamedComponents();
    }

    public Component getComponent(String compname1) {
        for (ComponentVariable cv : this.assembly.getAssemblyNamedComponents()) {
            if (!cv.getVarName().equals(compname1)) continue;
            return cv.getComponentType();
        }
        return null;
    }

    public Composition shallowCopy() {
        Composition copy = new Composition();
        Assembly ass = this.assembly.shallowCopy();
        copy.setAssembly(ass);
        ass.setOwner(this.getOwner());
        copy.comment = this.comment;
        copy.owner = this.owner;
        copy.promotionLinks = this.promotionLinks != null ? (HashMap)this.promotionLinks.clone() : null;
        return copy;
    }

    public ComponentVariable getComponentVariable(String name) {
        return this.assembly.getComponentVariable(name);
    }
}

