/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.checks.errorLogger.KmlLogger;
import costo.graph.KmlContext;
import costo.graph.Variable;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlSignature;
import costo.graph.expressions.Localizable;
import costo.graph.types.CostoType;
import java.util.ArrayList;
import java.util.Set;

public class DelegateKmlContext
implements KmlContext {
    KmlContext evalContext;
    Localizable elem;
    KmlContext loggingContext;

    public DelegateKmlContext(KmlContext evalContext, Localizable elem, KmlContext loggingContext) {
        this.evalContext = evalContext;
        this.elem = elem;
        this.loggingContext = loggingContext;
    }

    public int getColumn() {
        return this.elem.getColumn();
    }

    public int getLine() {
        return this.elem.getLine();
    }

    public String getPositionAsText() {
        return this.elem.getPositionAsText();
    }

    public void setColumn(int column) {
        this.elem.setColumn(column);
    }

    public void setLine(int line) {
        this.elem.setLine(line);
    }

    @Override
    public void addFunction(KmlSignature sig) {
        this.evalContext.addFunction(sig);
    }

    @Override
    public Variable lookupVariable(String n) {
        int dotpos;
        Variable var = this.evalContext.lookupVariable(n);
        if (var == null && (dotpos = n.indexOf(46)) != -1) {
            var = this.evalContext.lookupVariable(n.substring(dotpos + 1));
        }
        return var;
    }

    @Override
    public KmlSignature resolveCommunication(KmlCommunication comm) {
        return this.evalContext.resolveCommunication(comm);
    }

    @Override
    public KmlSignature resolveFunction(String functionName, ArrayList<CostoType> operandsTypes, KmlExpression source) {
        return this.evalContext.resolveFunction(functionName, operandsTypes, source);
    }

    @Override
    public CostoType resolveType(String name) {
        return this.evalContext.resolveType(name);
    }

    @Override
    public String getFilePath() {
        return this.loggingContext.getFilePath();
    }

    @Override
    public KmlLogger getLogger() {
        return this.loggingContext.getLogger();
    }

    @Override
    public String getName() {
        return this.loggingContext.getName();
    }

    @Override
    public void setFilePath(String fp) {
        this.loggingContext.setFilePath(fp);
    }

    @Override
    public void setLogger(KmlLogger log) {
        this.loggingContext.setLogger(log);
    }

    @Override
    public Set<KmlSignature> getAllFunctions() {
        return this.evalContext.getAllFunctions();
    }
}

