/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.KmlElement;
import costo.graph.State;
import costo.graph.Transition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Graph
extends KmlElement {
    protected ArrayList<Transition> transitionList = new ArrayList();
    protected HashMap<String, State> stateMap = new HashMap();

    public void addTransition(Transition a) {
        this.transitionList.add(a);
        a.setTarget(this.updateAndGetState(a.getTarget()));
        a.setSource(this.updateAndGetState(a.getSource()));
        a.setOptindex(this.transitionList.size());
    }

    public void addTransitions(ArrayList<Transition> al) {
        if (al == null) {
            return;
        }
        for (Transition element : al) {
            this.addTransition(element);
        }
    }

    public void addStates(ArrayList<State> al) {
        for (State current : al) {
            this.updateState(current);
        }
    }

    public State updateAndGetState(State n) {
        if (this.stateMap.entrySet().contains(n)) {
            return n;
        }
        State exist = this.stateMap.get(n.getName());
        if (exist == null) {
            this.addState(n);
            exist = n;
        } else {
            exist.updateServices(n);
        }
        return exist;
    }

    public void updateState(State n) {
        this.updateAndGetState(n);
    }

    public void addState(State n) {
        this.stateMap.put(n.getName(), n);
    }

    public State addState(String s) {
        State noeud = new State(s);
        this.stateMap.put(s, noeud);
        return noeud;
    }

    public Transition getTransition(int num) {
        return this.transitionList.get(num);
    }

    public int getNbTransition() {
        return this.transitionList.size();
    }

    public Iterator<Transition> iteratorOnTransitions() {
        return this.transitionList.iterator();
    }

    public ArrayList<Transition> getTransitions() {
        return this.transitionList;
    }

    public State getState(String s) {
        return this.stateMap.get(s);
    }

    public int getNbState() {
        return this.stateMap.size();
    }

    public Iterator<State> iteratorOnStates() {
        return this.stateMap.values().iterator();
    }

    public HashMap<String, State> getStatesMap() {
        return this.stateMap;
    }

    public void removeTransition(Transition toremove) {
        this.transitionList.remove(toremove);
        toremove.getSource().getOutGoingTransitions().remove(toremove);
        toremove.getTarget().getInComingTransitions().remove(toremove);
    }
}

