/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.KmlStructuralElement;
import costo.graph.expressions.KmlPredicate;
import java.util.HashMap;
import java.util.Map;

public class KmlAssertionClause
extends KmlStructuralElement {
    private HashMap<String, KmlPredicate> assertMap;
    private String clausename;
    private boolean redefinedClause;
    private boolean weakenedClause;
    private boolean strengthenedClause;
    private boolean constructedWithClause;
    private KmlAssertionClause originalclause;

    public KmlAssertionClause(String clausename) {
        this.clausename = clausename;
    }

    public HashMap<String, KmlPredicate> getAssertMap() {
        return this.assertMap;
    }

    public void setAssertMap(HashMap<String, KmlPredicate> assertMap) {
        this.assertMap = assertMap;
    }

    public String getClausename() {
        return this.clausename;
    }

    public void setClausename(String clausename) {
        this.clausename = clausename;
    }

    public boolean isRedefinedClause() {
        return this.redefinedClause;
    }

    public void setRedefinedClause(boolean redefinedClause) {
        this.redefinedClause = redefinedClause;
    }

    public boolean isWeakenedClause() {
        return this.weakenedClause;
    }

    public void setWeakenedClause(boolean weakenedClause) {
        this.weakenedClause = weakenedClause;
        this.redefinedClause = true;
        if (this.weakenedClause) {
            this.strengthenedClause = false;
        }
    }

    public boolean isStrengthenedClause() {
        return this.strengthenedClause;
    }

    public void setStrengthenedClause(boolean strengthenedClause) {
        this.strengthenedClause = strengthenedClause;
        this.redefinedClause = true;
        if (this.strengthenedClause) {
            this.weakenedClause = false;
        }
    }

    public boolean isConstructedWithClause() {
        return this.constructedWithClause;
    }

    public void setConstructedWithClause(boolean constructedWithClause) {
        this.constructedWithClause = constructedWithClause;
    }

    public KmlAssertionClause getOriginalclause() {
        return this.originalclause;
    }

    public void setOriginalclause(KmlAssertionClause originalclause) {
        this.originalclause = originalclause;
    }

    public boolean isUnchanged() {
        return !this.weakenedClause && !this.strengthenedClause;
    }

    public boolean isEmpty() {
        return this.assertMap == null || this.assertMap.isEmpty();
    }

    public HashMap<String, KmlPredicate> getObservablePart() {
        return this.getObsOrNonobsPart(true);
    }

    public HashMap<String, KmlPredicate> getNonObservablePart() {
        return this.getObsOrNonobsPart(false);
    }

    private HashMap<String, KmlPredicate> getObsOrNonobsPart(boolean b) {
        if (this.assertMap == null) {
            return null;
        }
        HashMap<String, KmlPredicate> part = new HashMap<String, KmlPredicate>();
        for (Map.Entry<String, KmlPredicate> entry : this.assertMap.entrySet()) {
            if (entry.getValue().isObservable() != b) continue;
            part.put(entry.getKey(), entry.getValue());
        }
        return part;
    }

    public String toString() {
        if (this.assertMap == null || this.assertMap.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (this.redefinedClause) {
            builder.append("Redefined ");
        }
        builder.append(this.clausename);
        builder.append(" ");
        if (this.strengthenedClause) {
            builder.append(" Stronger ");
        } else if (this.weakenedClause) {
            builder.append(" Weaker ");
        }
        if (this.constructedWithClause) {
            builder.append(" With ");
        }
        for (KmlPredicate expr : this.assertMap.values()) {
            if (expr.isObservable()) {
                builder.append(" obs ");
            }
            builder.append(expr.toString());
            builder.append("\n");
        }
        return builder.toString();
    }
}

