/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.checks.process.ObservablePredicateCheckingVisitor;
import costo.graph.Assembly;
import costo.graph.ContextMapping;
import costo.graph.DelegateKmlContext;
import costo.graph.KmlContext;
import costo.graph.KmlElement;
import costo.graph.Service;
import costo.graph.ServiceIdentifier;
import costo.graph.Spec;
import costo.graph.expressions.CommunicationVisitorExtractor;
import costo.graph.expressions.KmlCommunication;
import costo.graph.expressions.KmlSignature;
import costo.graph.expressions.KmlTypedStuff;
import costo.graph.visitors.KmlElementAbstractVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class Link
extends KmlElement {
    public static final Link UNRESOLVEDLINK = new Link("UNKNOWN", 0, 0);
    private String name;
    private Link superLink;
    private int line;
    private int column;
    private int linktype;
    private ServiceIdentifier first;
    private ServiceIdentifier second;
    private HashMap<String, Link> namedSublinks;
    private KmlContext owner;
    private HashMap<String, ContextMapping> contextMapping;
    private HashMap<String, String> messageMapping;
    private boolean loaded;

    public Link(String name, int line, int column) {
        this.name = name;
        this.line = line;
        this.column = column;
    }

    public boolean isSubLink() {
        return this.superLink == null;
    }

    public HashMap<String, ContextMapping> getContextMapping() {
        return this.contextMapping;
    }

    public void setContextMapping(HashMap<String, ContextMapping> contextMapping) {
        this.contextMapping = contextMapping;
    }

    public HashMap<String, String> getMessageMapping() {
        return this.messageMapping;
    }

    public void setMessageMapping(HashMap<String, String> messageMapping) {
        this.messageMapping = messageMapping;
    }

    public void setSublinksNames(ArrayList<String> namelist) {
        if (namelist == null || namelist.size() == 0) {
            return;
        }
        this.namedSublinks = new HashMap();
        for (String s : namelist) {
            this.namedSublinks.put(s, UNRESOLVEDLINK);
        }
    }

    public Link getSuperLink() {
        return this.superLink;
    }

    protected void setSuperLink(Link superlink) {
        this.superLink = superlink;
    }

    public void resolveSubLinks(HashMap<String, Link> links) {
        Link l = null;
        if (this.namedSublinks != null) {
            for (String s : this.namedSublinks.keySet()) {
                l = links.get(s);
                if (l == null) {
                    this.owner.getLogger().log("sublink " + s + " not found ", this, "RESOLUTION ERROR", this.getLine(), this.getColumn(), this.owner.getFilePath());
                    continue;
                }
                this.namedSublinks.put(s, l);
                if (l.getSuperLink() != null) {
                    this.owner.getLogger().log("sublink " + s + " is shared between " + this.getName() + " and " + l.getName(), this, "RESOLUTION ERROR", this.getLine(), this.getColumn(), this.owner.getFilePath());
                    continue;
                }
                l.setSuperLink(this);
            }
        }
    }

    public ServiceIdentifier getFirst() {
        return this.first;
    }

    public void setFirst(ServiceIdentifier first) {
        this.first = first;
    }

    public ServiceIdentifier getSecond() {
        return this.second;
    }

    public void setSecond(ServiceIdentifier second) {
        this.second = second;
    }

    public Link() {
    }

    public boolean equals(Object obj) {
        if (obj instanceof Link) {
            Link other = (Link)obj;
            return other.first.equals(this.first) && other.second.equals(this.second);
        }
        return false;
    }

    public int getLinktype() {
        return this.linktype;
    }

    public void setLinktype(int linktype) {
        this.linktype = linktype;
    }

    public void setLinktype(String slinktype) {
        this.linktype = Spec.getLinkType(slinktype);
    }

    public String toString() {
        String s = String.valueOf(Spec.getLinkType(this.getLinktype())) + "    " + this.first + " " + this.second + (this.contextMapping != null ? Spec.listToString(this.contextMapping.values(), "\n \t context mapping\n", ",\n\t", "\n") : "") + Spec.mapToString(this.messageMapping, "\n \t message mapping\n", " = ", ",\n\t", "\n") + (this.namedSublinks != null ? Spec.listToString(this.namedSublinks.keySet(), " sublinks {", ",", "}\n") : "");
        return s;
    }

    public Collection<Link> getSubLinks() {
        if (this.namedSublinks == null) {
            return null;
        }
        return this.namedSublinks.values();
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public void setColumn(int column) {
        this.column = column;
    }

    public KmlContext getOwner() {
        return this.owner;
    }

    public void setOwner(KmlContext owner) {
        this.owner = owner;
        if (this.getSubLinks() != null) {
            for (Link lnk : this.getSubLinks()) {
                if (lnk == null) continue;
                lnk.setOwner(owner);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public HashMap<String, Link> getNamedSublinks() {
        return this.namedSublinks;
    }

    public void setNamedSublinks(HashMap<String, Link> namedSublinks) {
        this.namedSublinks = namedSublinks;
    }

    public boolean resolveType(KmlContext context) {
        boolean res = true;
        return res;
    }

    private void checkMessageMappings() {
        if (this.isPromotionLink()) {
            return;
        }
        ServiceIdentifier provided = this.first.getServ().isProvided() ? this.first : this.second;
        ServiceIdentifier required = provided == this.first ? this.second : this.first;
        CommunicationVisitorExtractor providedcomvisit = new CommunicationVisitorExtractor(24, "_CALLER");
        KmlElementAbstractVisitor visitor = new KmlElementAbstractVisitor(providedcomvisit);
        provided.getServ().accept(visitor);
        providedcomvisit.getComms();
        ArrayList<KmlCommunication> callercomms = new ArrayList<KmlCommunication>();
        providedcomvisit.setChannelmask(required.getServ().getName());
        Collection<Service> callers = required.getCompVar().getComponentType().getLocalCallersOfRequiredServices(required.getServ());
        for (Service caller : callers) {
            providedcomvisit.reset();
            caller.accept(visitor);
            callercomms.addAll(providedcomvisit.getComms());
        }
    }

    private void checkIfAllVirtualVariableAreAssigned() {
        if (this.first.isLoaded() && this.first.getServ() != null && this.first.getServ().isRequired() && this.first.getServ().getVariables() != null) {
            this.checkIfAllVirtualVariableAreAssignedFor(this.first, this.second);
        }
        if (this.second.isLoaded() && this.second.getServ() != null && this.second.getServ().isRequired() && this.second.getServ().getVariables() != null) {
            this.checkIfAllVirtualVariableAreAssignedFor(this.second, this.first);
        }
    }

    private void checkIfAllVirtualVariableAreAssignedFor(ServiceIdentifier req, ServiceIdentifier prov) {
        ContextMapping cm = null;
        for (String vVarName : req.getServ().getVariables().keySet()) {
            if (this.contextMapping != null) {
                cm = this.contextMapping.get(String.valueOf(req.getCompVarName()) + "." + vVarName);
            }
            if (cm != null) continue;
            this.owner.getLogger().log("virtual Variable " + vVarName + " is missing a mapping ", this, "COMPATIBILITY ERROR", this.getLine(), this.getColumn(), this.owner.getFilePath());
        }
        if (this.contextMapping != null) {
            for (ContextMapping cmap : this.contextMapping.values()) {
                DelegateKmlContext newcontext = new DelegateKmlContext(req.getServ(), cmap, this.owner);
                cmap.getVirtualVariable().resolveType(newcontext);
                if (prov.getCompVar().getComponentType() == null) {
                    System.out.println(prov.getCompVar() + " not found in" + this.owner.getName());
                    this.owner.getLogger().log("unknown comp variable " + prov.getCompVar(), this, "RESOLUTION ERROR", cmap.getLine(), cmap.getColumn(), this.owner.getFilePath());
                    return;
                }
                DelegateKmlContext provcontext = new DelegateKmlContext(prov.getCompVar().getComponentType(), cmap, this.owner);
                boolean rightExprOK = cmap.getValue().resolveType(provcontext);
                cmap.getValue().accept(new ObservablePredicateCheckingVisitor(provcontext));
                if (!rightExprOK || KmlTypedStuff.typeCheck(cmap.getVirtualVariable(), cmap.getValue().getType())) continue;
                this.owner.getLogger().log(" in context mapping: " + cmap.getValue() + " of type " + cmap.getValue().getType() + "cannot be mapped to " + cmap.getVirtualVariable() + " of type " + cmap.getVirtualVariable().getType(), this, "TYPE ERROR", cmap.getLine(), cmap.getColumn(), this.owner.getFilePath());
            }
        }
    }

    public void resolve(Assembly assembly) {
        this.first.resolve(assembly);
        this.second.resolve(assembly);
        boolean bl = this.loaded = this.first.isLoaded() && this.second.isLoaded();
        if (this.isLoaded()) {
            this.checkServicesSignatureMatch();
            if (this.linktype == 0) {
                this.assignLinkType();
            } else {
                this.checkPRRP();
            }
        }
        this.checkIfAllVirtualVariableAreAssigned();
    }

    private void assignLinkType() {
        if (this.first.getServ().isProvided()) {
            this.setLinktype(1);
        } else {
            this.setLinktype(2);
        }
    }

    private void checkPRRP() {
        if (this.getClient() != this.getRequired() || this.getServer() != this.getProvided()) {
            this.owner.getLogger().log("services " + this.first.toString() + " and " + this.second.toString() + " are not ordered according to " + Spec.getLinkType(this.linktype), this, "LINK ORDER ERROR", this.getLine(), this.getColumn(), this.owner.getFilePath());
        }
    }

    public boolean isPromotionLink() {
        return this.first.getCompVarName().equals("SELF") || this.second.getCompVarName().equals("SELF");
    }

    private void checkServicesSignatureMatch() {
        KmlSignature secondsig;
        if (this.first.getServ() == null || this.second.getServ() == null) {
            System.err.println("remember to link promoted services");
            return;
        }
        KmlSignature firstsig = this.first.getServ().getKmlSignature();
        if (!firstsig.equalsIgnoreName(secondsig = this.second.getServ().getKmlSignature())) {
            this.owner.getLogger().log("services " + this.first.toString() + " and " + this.second.toString() + " have incompatible signatures : " + firstsig.toString() + " != " + secondsig.toString(), this, "LINK COMPATIBILITY ERROR", this.getLine(), this.getColumn(), this.owner.getFilePath());
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    @Deprecated
    public ServiceIdentifier getClient() {
        if (this.linktype == 2) {
            return this.first;
        }
        return this.second;
    }

    public ServiceIdentifier getProvided() {
        if (this.first.getServ().isProvided()) {
            return this.first;
        }
        return this.second;
    }

    public ServiceIdentifier getRequired() {
        if (this.first.getServ().isRequired()) {
            return this.first;
        }
        return this.second;
    }

    @Deprecated
    public ServiceIdentifier getServer() {
        if (this.linktype == 1) {
            return this.first;
        }
        return this.second;
    }

    public ServiceIdentifier getOther(ServiceIdentifier reqsi) {
        if (reqsi.equals(this.first)) {
            return this.second;
        }
        if (reqsi.equals(this.second)) {
            return this.first;
        }
        return null;
    }
}

