/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.Assembly;
import costo.graph.ComponentFactory;
import costo.graph.ComponentVariable;
import costo.graph.Link;
import costo.graph.Service;
import costo.graph.VariableData;
import costo.graph.expressions.KmlIdentifier;

public class ServiceIdentifier
extends VariableData {
    private ComponentVariable compVar;
    private Service serv;

    public ServiceIdentifier(ComponentVariable compVar, Service serv) {
        super(serv.getName(), compVar.getVarName(), 0, 0);
        this.compVar = compVar;
        this.serv = serv;
    }

    public ServiceIdentifier(String varName, String typeName, int line, int column) {
        super(varName, typeName, line, column);
    }

    public ServiceIdentifier(KmlIdentifier id) {
        String sid = id.getRawValue();
        int sep = sid.lastIndexOf(46);
        if (sep == -1) {
            this.setTypeName("SELF");
            this.setVarName(sid);
        } else {
            this.setVarName(sid.substring(sep + 1));
            this.setTypeName(sid.substring(0, sep));
        }
        this.setLine(id.getLine());
        this.setColumn(id.getColumn());
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTypeName()) + "." + this.getVarName();
    }

    public String getCompVarName() {
        return this.getTypeName();
    }

    public String getServiceName() {
        return this.getVarName();
    }

    @Override
    public void loadType(ComponentFactory cf) {
    }

    public void setCompVar(ComponentVariable compVar) {
        this.compVar = compVar;
    }

    public void setServ(Service serv) {
        this.serv = serv;
    }

    public ComponentVariable getCompVar() {
        return this.compVar;
    }

    public Service getServ() {
        return this.serv;
    }

    public void resolve(Assembly assembly) {
        this.compVar = assembly.getComponentVariable(this.getCompVarName());
        if (this.compVar == null) {
            assembly.getContext().getLogger().log("Can not resolve compname " + this.getCompVarName(), this, "RESOLUTION ERROR", this.getLine(), this.getColumn(), assembly.getFilePath());
            return;
        }
        if (!this.compVar.isLoaded()) {
            this.compVar.loadType(assembly.getContext());
        }
        if (this.compVar.isLoaded()) {
            this.serv = this.compVar.getComponentType().getService(this.getServiceName());
            if (this.serv == null) {
                assembly.getContext().getLogger().log("Can not resolve service " + this.getServiceName() + " in " + this.compVar, this, "RESOLUTION ERROR", this.getLine(), this.getColumn(), assembly.getFilePath());
            } else {
                this.isLoaded = true;
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceIdentifier)) {
            return false;
        }
        ServiceIdentifier other = (ServiceIdentifier)obj;
        return other.getCompVar().equals(this.compVar) && other.getServ().equals(this.serv);
    }

    public Link getLink() {
        for (Link l : this.getCompVar().getContext().getLinks().values()) {
            if (!l.getFirst().equals(this) && !l.getSecond().equals(this)) continue;
            return l;
        }
        return null;
    }
}

