/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.Component;
import costo.graph.KmlElement;
import costo.graph.LTS;
import costo.graph.Label;
import costo.graph.Service;
import costo.graph.ServiceHook;
import costo.graph.Spec;
import costo.graph.State;
import costo.graph.Transition;
import java.util.ArrayList;

public class ServiceInterface
extends KmlElement {
    private ArrayList<String> receptions;
    private ArrayList<String> sendings;
    private ArrayList<String> subprovided;
    private ArrayList<String> calrequired;
    private ArrayList<String> extrequired;
    private ArrayList<String> intrequired;

    public ServiceInterface() {
        this.calrequired = new ArrayList();
        this.extrequired = new ArrayList();
        this.subprovided = new ArrayList();
        this.intrequired = new ArrayList();
        this.receptions = new ArrayList();
        this.sendings = new ArrayList();
    }

    public ServiceInterface(LTS auto) {
        this();
        if (auto == null) {
            return;
        }
        for (State each : auto.getStatesMap().values()) {
            ArrayList<ServiceHook> shs = each.getServices();
            if (shs == null) continue;
            for (ServiceHook sh : shs) {
                this.subprovided.add(sh.getServname());
            }
        }
        for (Transition t : auto.transitionList) {
            Label e = t.getLabel();
            String port = e.getChannel();
            String message = e.getMessage();
            switch (e.getActionType()) {
                case 1: {
                    if ("__CALLER".equals(port)) {
                        this.calrequired.add(message);
                        break;
                    }
                    if ("__SELF".equals(port)) {
                        this.intrequired.add(message);
                        break;
                    }
                    this.extrequired.add(message);
                    break;
                }
                case 512: {
                    this.subprovided.add(message);
                    break;
                }
                case 16: {
                    if (!"__CALLER".equals(port)) break;
                    this.sendings.add(message);
                    break;
                }
                case 8: {
                    if (!"__CALLER".equals(port)) break;
                    this.receptions.add(message);
                }
            }
        }
    }

    public ServiceInterface(ServiceInterface s) {
        this.calrequired = (ArrayList)s.getCalrequired().clone();
        this.extrequired = (ArrayList)s.getExtrequired().clone();
        this.subprovided = (ArrayList)s.getSubprovided().clone();
        this.intrequired = (ArrayList)s.getIntrequired().clone();
        this.receptions = (ArrayList)s.getReceptions().clone();
        this.sendings = (ArrayList)s.getSendings().clone();
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + Spec.listToString(this.subprovided, "  subprovides : {", ",", "}\n");
        s = String.valueOf(s) + Spec.listToString(this.calrequired, "  calrequires : {", ",", "}\n");
        s = String.valueOf(s) + Spec.listToString(this.extrequired, "  extrequires : {", ",", "}\n");
        s = String.valueOf(s) + Spec.listToString(this.intrequired, "  intrequires : {", ",", "}\n");
        s = String.valueOf(s) + Spec.listToString(this.receptions, "  receptions : {", ",", "}\n");
        if ((s = String.valueOf(s) + Spec.listToString(this.sendings, "  sendings : {", ",", "}\n")).length() > 0) {
            s = "Interface \n" + s;
        }
        return s;
    }

    public ArrayList<String> getCalrequired() {
        return this.calrequired;
    }

    public ArrayList<String> getAllRequired() {
        ArrayList<String> all = new ArrayList<String>();
        all.add("__CALLER");
        all.addAll(this.calrequired);
        all.addAll(this.extrequired);
        all.addAll(this.intrequired);
        return all;
    }

    public ArrayList<String> getAllProvided() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(this.subprovided);
        return all;
    }

    public void addCalrequired(ArrayList<String> icalrequired) {
        if (icalrequired != null) {
            this.calrequired.addAll(icalrequired);
        }
    }

    public ArrayList<String> getExtrequired() {
        return this.extrequired;
    }

    public void addExtrequired(ArrayList<String> extrequired) {
        if (extrequired != null) {
            this.extrequired.addAll(extrequired);
        }
    }

    public ArrayList<String> getIntrequired() {
        return this.intrequired;
    }

    public void addIntrequired(ArrayList<String> intrequired) {
        if (intrequired != null) {
            this.intrequired.addAll(intrequired);
        }
    }

    public ArrayList<String> getSubprovided() {
        return this.subprovided;
    }

    public void addSubprovided(ArrayList<String> subprovided) {
        if (subprovided != null) {
            this.subprovided.addAll(subprovided);
        }
    }

    public boolean isCompatibleWith(ServiceInterface s) {
        return true;
    }

    public ArrayList<String> getReceptions() {
        return this.receptions;
    }

    public void addReceptions(ArrayList<String> receptions) {
        if (receptions != null) {
            this.receptions.addAll(receptions);
        }
    }

    public ArrayList<String> getSendings() {
        return this.sendings;
    }

    public void addSendings(ArrayList<String> sendings) {
        if (sendings != null) {
            this.sendings.addAll(sendings);
        }
    }

    public void setCalrequired(ArrayList<String> calrequired) {
        this.calrequired = calrequired == null ? new ArrayList() : calrequired;
    }

    public void setExtrequired(ArrayList<String> extrequired) {
        this.extrequired = extrequired == null ? new ArrayList() : extrequired;
    }

    public void setIntrequired(ArrayList<String> intrequired) {
        this.intrequired = intrequired == null ? new ArrayList() : intrequired;
    }

    public void setReceptions(ArrayList<String> receptions) {
        this.receptions = receptions == null ? new ArrayList() : receptions;
    }

    public void setSendings(ArrayList<String> sendings) {
        this.sendings = sendings == null ? new ArrayList() : sendings;
    }

    public void setSubprovided(ArrayList<String> subprovided) {
        this.subprovided = subprovided == null ? new ArrayList() : subprovided;
    }

    public String toStringXML() {
        String s = "<interface>\n";
        s = String.valueOf(s) + Spec.listToString(this.subprovided, "<subprovides>\n<service name=\"", "\"/>\n<service name=\"", "\"/>\n</subprovides>\n");
        s = String.valueOf(s) + Spec.listToString(this.calrequired, "<calrequires>\n<service name=\"", "\"/>\n<service name=\"", "\"/>\n</calrequires>\n");
        s = String.valueOf(s) + Spec.listToString(this.extrequired, "<extrequires>\n<service name=\"", "\"/>\n<service name=\"", "\"/>\n</extrequires>\n");
        s = String.valueOf(s) + Spec.listToString(this.intrequired, "<intrequires>\n<service name=\"", "\"/>\n<service name=\"", "\"/>\n</intrequires>\n");
        s = String.valueOf(s) + Spec.listToString(this.receptions, "<receptions>\n<message name=\"", "\"/>\n<message name=\"", "\"/>\n</receptions>\n");
        s = String.valueOf(s) + Spec.listToString(this.sendings, "<sendings>\n<message name=\"", "\"/>\n<message name=\"", "\"/>\n</sendings>\n");
        return String.valueOf(s) + "</interface>";
    }

    public void checkExistenceAndUse(Component owner) {
        this.checkServiceExistence(this.subprovided, owner, true);
        this.checkServiceExistence(this.intrequired, owner, true);
        this.checkServiceExistence(this.extrequired, owner, false);
        this.checkServiceExistence(this.calrequired, owner, false);
    }

    private void checkServiceExistence(ArrayList<String> servicelist, Component owner, boolean provided) {
        if (servicelist == null) {
            return;
        }
        for (String sname : servicelist) {
            Service serv = owner.getService(sname);
            if (serv == null) {
                owner.getLogger().log("Service " + sname + " not found", this, "RESOLUTION ERROR", this.getLine(), this.getColumn(), owner.getFilePath());
                continue;
            }
            if (serv.isProvided() == provided) continue;
            owner.getLogger().log("Service " + sname + " should be a " + (provided ? "provided" : "required") + " service", this, "INTERFACE ERROR", this.getLine(), this.getColumn(), owner.getFilePath());
        }
    }

    public ArrayList<String> getRequired() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(this.extrequired);
        all.addAll(this.intrequired);
        return all;
    }
}

