/*
 * Decompiled with CFR 0.152.
 */
package costo.graph;

import costo.graph.Service;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class Spec {
    public static final String WEAKER = "WEAKER";
    public static final String STRONGER = "STRONGER";
    public static final String SI_SUBPROVIDES = "subprovides";
    public static final String SI_CALREQUIRES = "calrequires";
    public static final String SI_EXTREQUIRES = "extrequires";
    public static final String SI_INTREQUIRES = "intrequires";
    public static final String SI_MANDATORY = "mandatory";
    public static final String CI_REQUIRES = "requires";
    public static final String CI_PROVIDES = "provides";
    public static final String CI_CONFIG = "config";
    public static final String CI_AUTORUN = "autorun";
    public static final int PROVIDED = 1;
    public static final int REQUIRED = 2;
    public static final int DIRECTLYACCESSIBLE = 4;
    public static final int HIDDEN = 8;
    public static final int PROMOTED = 16;
    public static final int SELFDEFINED = 32;
    public static final int NONE = 0;
    public static final int CALL = 1;
    public static final int START = 2;
    public static final int RCV_RESULT = 4;
    public static final int RECEIVE = 8;
    public static final int EMIT = 16;
    public static final int EMIT_RESULT = 32;
    public static final int INTERNAL = 64;
    public static final int INTERNAL_CALL = 128;
    public static final int NOP = 256;
    public static final int MANDATORY_CALL = 512;
    public static final int PIPE_OPERATOR = 1024;
    public static final int SEQUENCE = 1;
    public static final int PARALLEL = 2;
    public static final int COLATERAL = 3;
    public static final int XOR = 4;
    public static final int OR = 5;
    public static final int PR = 1;
    public static final int RP = 2;
    public static final int RR = 3;
    public static final int PP = 4;
    public static final int SRP = 5;
    public static final int SRSP = 6;
    public static final int PSR = 7;
    public static final int SPSR = 8;
    private static int number;
    public static Service INCORRECT_SERVICE;

    static {
        INCORRECT_SERVICE = new Service("INCORRECT", false);
    }

    public static int getActionType(String action) {
        if (action.equals("!!")) {
            return 1;
        }
        if (action.equals("??")) {
            return 4;
        }
        if (action.equals("?")) {
            return 8;
        }
        if (action.equals("!")) {
            return 16;
        }
        return 0;
    }

    public static String getActionType(int action) {
        switch (action) {
            case 32: {
                return "!!";
            }
            case 1: {
                return "!!";
            }
            case 2: {
                return "??";
            }
            case 4: {
                return "??";
            }
            case 8: {
                return "?";
            }
            case 16: {
                return "!";
            }
        }
        return "";
    }

    public static int getLinkType(String linktype) {
        if (linktype.equals("r-r")) {
            return 3;
        }
        if (linktype.equals("p-p")) {
            return 4;
        }
        if (linktype.equals("p-r")) {
            return 1;
        }
        if (linktype.equals("r-p")) {
            return 2;
        }
        return 0;
    }

    public static String getLinkType(int linktype) {
        switch (linktype) {
            case 0: {
                return "";
            }
            case 3: {
                return "r-r";
            }
            case 4: {
                return "p-p";
            }
            case 2: {
                return "r-p";
            }
            case 1: {
                return "p-r";
            }
            case 5: {
                return "sr-p";
            }
            case 6: {
                return "sr-sp";
            }
            case 7: {
                return "p-sr";
            }
            case 8: {
                return "sp-sr";
            }
        }
        return "";
    }

    public static int reverseLinkType(int linktype) {
        switch (linktype) {
            case 0: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    public static int reverseActionType(int actiontype) {
        switch (actiontype) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 32;
            }
            case 32: {
                return 4;
            }
            case 16: {
                return 8;
            }
            case 8: {
                return 16;
            }
        }
        return 0;
    }

    public static int getIndex() {
        return ++number;
    }

    public static final String listToString(Collection c, String start, String separator, String end) {
        if (c == null || c.isEmpty()) {
            return "";
        }
        String s = start;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            s = String.valueOf(s) + iter.next();
            if (!iter.hasNext()) continue;
            s = String.valueOf(s) + separator;
        }
        return String.valueOf(s) + end;
    }

    public static final String mapToString(Map m, String start, String kvseparator, String separator, String end) {
        if (m == null || m.isEmpty()) {
            return "";
        }
        String s = start;
        Iterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry ent = iter.next();
            s = String.valueOf(s) + ent.getKey() + kvseparator + ent.getValue();
            if (!iter.hasNext()) continue;
            s = String.valueOf(s) + separator;
        }
        return String.valueOf(s) + end;
    }

    public static final String maplistToString(Map m, String start, String kvseparator, String separator, String end, String vstart, String vseparator, String vend) {
        if (m == null || m.isEmpty()) {
            return "";
        }
        String s = start;
        Iterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry ent = iter.next();
            s = String.valueOf(s) + ent.getKey() + kvseparator + Spec.listToString((Collection)ent.getValue(), vstart, vseparator, vend);
            if (!iter.hasNext()) continue;
            s = String.valueOf(s) + separator;
        }
        return String.valueOf(s) + end;
    }

    public static final String mapmapToString(Map m, String start, String kvseparator, String separator, String end, String vstart, String vkvseparator, String vseparator, String vend) {
        if (m == null || m.isEmpty()) {
            return "";
        }
        String s = start;
        Iterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry ent = iter.next();
            s = String.valueOf(s) + ent.getKey() + kvseparator + Spec.mapToString((Map)ent.getValue(), vstart, vkvseparator, vseparator, vend);
            if (!iter.hasNext()) continue;
            s = String.valueOf(s) + separator;
        }
        return String.valueOf(s) + end;
    }
}

