/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlFunctionUseExpression;
import costo.graph.expressions.KmlSignature;
import costo.graph.types.CostoType;
import costo.graph.types.CostoUnknownType;
import java.util.ArrayList;

public class KmlBinOP
extends KmlFunctionUseExpression {
    protected KmlExpression leftOperand = null;
    protected KmlExpression rightOperand = null;
    protected String operator = "";

    public KmlBinOP() {
    }

    @Override
    public KmlExpression deepCopy() {
        KmlBinOP twin = new KmlBinOP(this.leftOperand.deepCopy(), this.rightOperand.deepCopy(), new String(this.operator));
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        twin.setLine(this.getLine());
        twin.setColumn(this.getColumn());
        twin.setFunction(this.function);
        return twin;
    }

    public KmlBinOP(KmlExpression leftOperand, KmlExpression rightOperand, String operator) {
        this.leftOperand = leftOperand;
        this.setColumn(leftOperand.getColumn());
        this.setLine(leftOperand.getLine());
        this.rightOperand = rightOperand;
        this.operator = operator;
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            this.leftOperand.accept(visitor);
            this.rightOperand.accept(visitor);
        }
    }

    public KmlExpression getLeftOperand() {
        return this.leftOperand;
    }

    public KmlExpression getRightOperand() {
        return this.rightOperand;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setLeftOperand(KmlExpression leftOperand) {
        this.leftOperand = leftOperand;
        this.setColumn(leftOperand.getColumn());
        this.setLine(leftOperand.getLine());
    }

    public void setRightOperand(KmlExpression rightOperand) {
        this.rightOperand = rightOperand;
    }

    @Override
    public String getRawValue() {
        return String.valueOf(this.leftOperand.getRawValue()) + " " + this.operator + " " + this.rightOperand.getRawValue();
    }

    @Override
    public boolean resolveType(KmlContext context) {
        boolean leftok = this.leftOperand.resolveType(context);
        boolean rightok = this.rightOperand.resolveType(context);
        ArrayList<CostoType> operandsTypes = new ArrayList<CostoType>();
        operandsTypes.add(this.leftOperand.getType());
        operandsTypes.add(this.rightOperand.getType());
        this.function = context.resolveFunction(this.operator, operandsTypes, this);
        if (this.function == null) {
            this.type = CostoUnknownType.instance;
        } else {
            this.type = this.function.getType();
            this.function.setOp(true);
        }
        return leftok && rightok;
    }

    @Override
    public ArrayList<KmlExpression> getOperands() {
        ArrayList<KmlExpression> list = new ArrayList<KmlExpression>();
        list.add(this.leftOperand);
        list.add(this.rightOperand);
        return list;
    }

    @Override
    public void setFunction(KmlSignature function) {
        this.setOperator(function.getName());
        super.setFunction(function);
    }
}

