/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.InterlocutorSet;
import costo.graph.KmlContext;
import costo.graph.Spec;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlSignature;
import costo.graph.types.CostoType;
import costo.graph.types.CostoVoid;
import java.util.ArrayList;

public class KmlCommunication
extends KmlExpression {
    boolean isReturnExpression = false;
    private InterlocutorSet interlocutorSet;
    private boolean synchronous = false;
    private String communicationName = "";
    private int actionType = 0;
    private ArrayList<KmlExpression> parameters;
    private KmlSignature signature;
    private boolean isDefaultChannel;

    public KmlCommunication(InterlocutorSet interlocutorSet, int actionType, String communicationName, ArrayList<KmlExpression> parameters) {
        this.interlocutorSet = interlocutorSet;
        this.setLine(interlocutorSet.getLine());
        this.setColumn(interlocutorSet.getColumn());
        this.communicationName = communicationName;
        this.actionType = actionType;
        this.parameters = parameters;
    }

    public KmlCommunication(InterlocutorSet interlocutorSet, String actionType, String communicationName, ArrayList<KmlExpression> parameters) {
        this(interlocutorSet, Spec.getActionType(actionType), communicationName, parameters);
    }

    public KmlCommunication(InterlocutorSet interlocutorSet, ArrayList<KmlExpression> parameters) {
        this(interlocutorSet, 32, "", parameters);
        this.isReturnExpression = true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this) && this.parameters != null) {
            for (KmlExpression operand : this.parameters) {
                operand.accept(visitor);
            }
        }
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public KmlExpression deepCopy() {
        ArrayList<KmlExpression> twinops = null;
        if (this.parameters != null) {
            twinops = new ArrayList<KmlExpression>();
            for (KmlExpression kmlExpression : this.parameters) {
                twinops.add(kmlExpression.deepCopy());
            }
        }
        KmlCommunication twin = new KmlCommunication(this.interlocutorSet.deepCopy(), this.actionType, this.communicationName, twinops);
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        twin.setLine(this.getLine());
        twin.setColumn(this.getColumn());
        return twin;
    }

    public String getCommunicationName() {
        return this.communicationName;
    }

    public void setCommunicationName(String communicationName) {
        this.communicationName = communicationName;
    }

    public int getActionType() {
        return this.actionType;
    }

    public void setActionType(int actionType) {
        this.actionType = actionType;
    }

    public ArrayList<KmlExpression> getParameters() {
        return this.parameters;
    }

    public void setParameters(ArrayList<KmlExpression> parameters) {
        this.parameters = parameters;
    }

    @Override
    public String getRawValue() {
        StringBuffer val = new StringBuffer();
        if (this.isReturnExpression) {
            val.append("SENDRESULT");
        } else {
            if (!this.isDefaultChannel) {
                val.append(this.interlocutorSet.toString());
            }
            val.append(Spec.getActionType(this.actionType));
            val.append(this.communicationName);
        }
        if (this.parameters != null) {
            val.append(Spec.listToString(this.parameters, "(", ",", ")"));
        }
        return val.toString();
    }

    @Override
    public boolean resolveType(KmlContext context) {
        if (this.isReturnExpression) {
            this.communicationName = context.getName();
        }
        if (this.getInterlocutorSet().getChannel().equals("DEFAULT")) {
            this.isDefaultChannel = true;
            switch (this.actionType) {
                case 1: 
                case 4: {
                    this.getInterlocutorSet().setChannel("_" + this.communicationName);
                    break;
                }
                default: {
                    this.getInterlocutorSet().setChannel("__CALLER");
                }
            }
        }
        if (this.parameters != null) {
            for (KmlExpression param : this.parameters) {
                param.resolveType(context);
            }
        }
        if (this.actionType == 1 && this.communicationName.equals(context.getName())) {
            this.actionType = 32;
        }
        if (this.actionType == 4 && this.communicationName.equals(context.getName())) {
            this.actionType = 2;
        }
        this.signature = context.resolveCommunication(this);
        if (this.signature != null) {
            ArrayList<CostoType> callParametersTypes = this.getParameterTypes(context);
            this.type = this.signature.getReturnType();
            switch (this.actionType) {
                case 1: {
                    if (this.signature.canBeCalledWithTypes(callParametersTypes)) break;
                    context.getLogger().log(" service " + this.signature.getRawValue() + "  can't be called with types " + Spec.listToString(callParametersTypes, "(", ";", ")") + " in " + this.getRawValue(), this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
                    break;
                }
                case 16: {
                    if (callParametersTypes == null || callParametersTypes.size() <= 0) break;
                    this.signature.setParameters(callParametersTypes);
                    break;
                }
                case 8: {
                    if (callParametersTypes == null || callParametersTypes.size() <= 0) break;
                    this.signature.setType(callParametersTypes.get(0));
                    break;
                }
                case 4: 
                case 32: {
                    if (this.parameters == null && (this.signature.getReturnType() == null || this.signature.getReturnType() == CostoVoid.instance) || this.isSynchronous() && (this.parameters == null || this.parameters.isEmpty())) break;
                    if (this.parameters == null || this.signature.getReturnType() == null || this.signature.getReturnType() == CostoVoid.instance) {
                        context.getLogger().log(" inconsistent number of parameters in " + this.getRawValue() + " : expecting " + this.signature.getReturnType(), this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
                        break;
                    }
                    if (this.parameters.size() != 1) {
                        context.getLogger().log(" in : " + this.getRawValue() + "Kmelia service" + this.signature.getRawValue() + "only returns one value ", this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
                        break;
                    }
                    this.parameters.get(0).resolveType(context);
                    if (this.parameters.get(0).getType() == null) {
                        context.getLogger().log("in : " + this.getRawValue() + "parameter" + this.parameters.get(0) + "of type null" + "does not conform to return type of service" + this.signature.getRawValue(), this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
                        break;
                    }
                    if (this.parameters.get(0).getType().conformsTo(this.signature.getReturnType())) break;
                    context.getLogger().log(" in : " + this.getRawValue() + "parameter" + this.parameters.get(0) + "of type " + this.parameters.get(0).getType() + "does not conform to return type of service" + this.signature.getRawValue(), this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
                    break;
                }
            }
        }
        if (!this.synchronous) {
            this.type = CostoVoid.instance;
        }
        return true;
    }

    public ArrayList<CostoType> getParameterTypes(KmlContext context) {
        ArrayList<CostoType> operandsTypes = null;
        if (this.parameters != null) {
            operandsTypes = new ArrayList<CostoType>();
            for (KmlExpression operand : this.parameters) {
                operand.resolveType(context);
                operandsTypes.add(operand.getType());
            }
        }
        return operandsTypes;
    }

    public InterlocutorSet getInterlocutorSet() {
        return this.interlocutorSet;
    }

    public void setInterlocutorSet(InterlocutorSet interlocutorSet) {
        this.interlocutorSet = interlocutorSet;
        this.setLine(interlocutorSet.getLine());
        this.setColumn(interlocutorSet.getColumn());
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    @Override
    public boolean isCommunication() {
        return true;
    }

    @Override
    public KmlCommunication getCommunicationAction() {
        return this;
    }

    public void redirectCaller(String channame) {
        System.out.println("=>redirect " + this.getInterlocutorSet().getChannel() + " by " + channame);
        this.getInterlocutorSet().setChannel(channame);
    }

    public KmlSignature getSignature() {
        return this.signature;
    }
}

