/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.ComponentVariable;
import costo.graph.KmlContext;
import costo.graph.Spec;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlSignature;
import costo.graph.types.CostoType;
import java.util.ArrayList;

public class KmlCompInitExpression
extends KmlExpression {
    private String tag;
    private ComponentVariable compvar;
    private String compvarname;
    private String initservicename;
    private ArrayList<KmlExpression> args;
    private ArrayList<CostoType> operandsTypes = new ArrayList();

    public KmlCompInitExpression(String compvarname, String initservicename, ArrayList<KmlExpression> args, int line) {
        this.compvarname = compvarname;
        this.initservicename = initservicename;
        this.args = args;
        this.setLine(line);
    }

    public KmlCompInitExpression() {
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean resolveType(KmlContext context) {
        boolean ok = true;
        if (this.args == null) {
            return true;
        }
        for (KmlExpression operand : this.args) {
            boolean newok = operand.resolveType(context);
            ok = ok && newok;
            this.operandsTypes.add(operand.getType());
        }
        return ok;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        super.accept(visitor);
    }

    @Override
    public String getRawValue() {
        StringBuffer sb = new StringBuffer();
        if (!"".equals(this.getTag())) {
            sb.append("@" + this.getTag() + " ");
        }
        sb.append(this.compvarname);
        sb.append(".");
        sb.append(this.initservicename);
        sb.append(Spec.listToString(this.args, "(", ",", ")"));
        return sb.toString();
    }

    @Override
    public CostoType getType() {
        return super.getType();
    }

    @Override
    public KmlExpression deepCopy() {
        return super.deepCopy();
    }

    public ComponentVariable getCompvar() {
        return this.compvar;
    }

    public void setCompvar(ComponentVariable compvar) {
        this.compvar = compvar;
    }

    public String getCompvarname() {
        return this.compvarname;
    }

    public String getInitservicename() {
        return this.initservicename;
    }

    public void resolveService(KmlContext context) {
        if (this.compvar == null) {
            return;
        }
        try {
            KmlSignature sig = this.compvar.getComponentType().getServicesMap().get(this.initservicename).getKmlSignature();
            if (!sig.canBeCalledWithTypes(this.operandsTypes)) {
                context.getLogger().log("service" + this.initservicename + " in component type" + this.compvar.getTypeName() + " can't be called with types " + Spec.listToString(this.operandsTypes, "(", ",", ")"), this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
            }
        }
        catch (Exception exception) {
            context.getLogger().log("init service" + this.initservicename + " not found ", this, "RESOLUTION ERROR", this.getLine(), this.getColumn(), context.getFilePath());
        }
    }

    public ArrayList<KmlExpression> getArgs() {
        return this.args;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

