/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlUnaryOp;
import costo.graph.types.CostoType;

public class KmlParOp
extends KmlUnaryOp {
    private String start;
    private String end;

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public KmlParOp(KmlExpression operand, String start, String end) {
        super(operand);
        this.start = start;
        this.setLine(operand.getLine());
        this.setColumn(operand.getColumn() - start.length());
        this.end = end;
    }

    @Override
    public String getRawValue() {
        return String.valueOf(this.start) + this.getOperand().getRawValue() + this.end;
    }

    @Override
    public boolean resolveType(KmlContext context) {
        return this.operand.resolveType(context);
    }

    @Override
    public CostoType getType() {
        return this.operand.getType();
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public KmlExpression deepCopy() {
        KmlParOp twin = new KmlParOp(this.operand.deepCopy(), this.start, this.end);
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        twin.setLine(this.getLine());
        twin.setColumn(this.getColumn());
        return twin;
    }
}

