/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.CostoLibrary;
import costo.graph.KmlContext;
import costo.graph.Spec;
import costo.graph.Variable;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.types.CostoBoolean;
import costo.graph.types.CostoType;
import java.util.ArrayList;
import java.util.HashMap;

public class KmlPredicate
extends KmlExpression {
    private String name = "";
    private HashMap<String, Variable> existentials;
    private HashMap<String, Variable> universals;
    private KmlExpression expression;
    private boolean observable = false;
    private boolean local = false;
    private boolean virtual = false;

    public KmlPredicate(String name, HashMap<String, Variable> universals, HashMap<String, Variable> existentials, KmlExpression expr) {
        this.name = name;
        this.existentials = existentials;
        this.universals = universals;
        this.expression = expr;
        this.setColumn(expr.getColumn());
        this.setLine(expr.getLine());
    }

    public KmlPredicate(String name, ArrayList<Variable> univ, ArrayList<Variable> exist, KmlExpression expr) {
        this.name = name;
        this.setUniversals(univ);
        this.setExistentials(exist);
        this.expression = expr;
        this.setColumn(expr.getColumn());
        this.setLine(expr.getLine());
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            this.expression.accept(visitor);
        }
    }

    @Override
    public KmlExpression deepCopy() {
        KmlPredicate twin = new KmlPredicate(this.name, this.universals, this.existentials, this.expression.deepCopy());
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        twin.setLine(this.getLine());
        twin.setColumn(this.getColumn());
        return twin;
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public HashMap<String, Variable> getExistentials() {
        return this.existentials;
    }

    public void setExistentials(HashMap<String, Variable> existentials) {
        this.existentials = existentials;
    }

    public void setExistentials(ArrayList<Variable> existentials) {
        if (existentials == null) {
            return;
        }
        this.existentials = new HashMap();
        for (Variable v : existentials) {
            this.existentials.put(v.getName(), v);
        }
    }

    public HashMap<String, Variable> getUniversals() {
        return this.universals;
    }

    public void setUniversals(HashMap<String, Variable> universals) {
        this.universals = universals;
    }

    public void setUniversals(ArrayList<Variable> univ) {
        if (univ == null) {
            return;
        }
        this.universals = new HashMap();
        for (Variable v : univ) {
            this.universals.put(v.getName(), v);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getRawValue() {
        String s = "";
        if (this.universals != null) {
            s = String.valueOf(s) + Spec.listToString(this.universals.values(), "forall ", ";", "");
        }
        if (this.existentials != null) {
            s = String.valueOf(s) + " " + Spec.listToString(this.existentials.values(), " exists ", ";", "");
        }
        if (this.existentials != null || this.universals != null) {
            s = String.valueOf(s) + " | ";
        }
        s = String.valueOf(s) + this.expression.getRawValue();
        return s;
    }

    public boolean isObservable() {
        return this.observable;
    }

    public void setObservable(boolean observable) {
        this.observable = observable;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public CostoType getType() {
        return CostoBoolean.instance;
    }

    @Override
    public boolean resolveType(KmlContext context) {
        CostoLibrary scope = new CostoLibrary();
        scope.setParentContext(context);
        if (this.existentials != null) {
            for (Variable var : this.existentials.values()) {
                var.getCtype().resolve(context);
                var.setObservable(true);
                scope.addConstant(var);
            }
        }
        if (this.universals != null) {
            for (Variable var : this.universals.values()) {
                var.getCtype().resolve(context);
                var.setObservable(true);
                scope.addConstant(var);
            }
        }
        if (!this.expression.resolveType(scope)) {
            return false;
        }
        if (!this.typeCheckAgainst(this.expression, CostoBoolean.instance)) {
            context.getLogger().log(this + " must be Boolean ", this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
            return false;
        }
        return true;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public KmlExpression getExpression() {
        return this.expression;
    }
}

