/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlFunctionUseExpression;
import costo.graph.expressions.KmlSignature;
import costo.graph.types.CostoType;
import java.util.ArrayList;

public class KmlUnaryOp
extends KmlFunctionUseExpression {
    protected KmlExpression operand;
    protected boolean prefix = false;
    protected String opname;

    public KmlUnaryOp(String opname, boolean prefix, KmlExpression operand) {
        this.opname = opname;
        this.setColumn(operand.getColumn());
        this.setLine(operand.getLine());
        this.prefix = prefix;
        this.operand = operand;
        String rvalue = String.valueOf(prefix ? opname : "") + operand.toString() + (prefix ? "" : opname);
        this.setRawValue(rvalue);
    }

    @Override
    public KmlExpression deepCopy() {
        KmlUnaryOp twin = new KmlUnaryOp(this.opname, this.prefix, this.operand.deepCopy());
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        twin.setLine(this.getLine());
        twin.setColumn(this.getColumn());
        return twin;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            this.operand.accept(visitor);
        }
    }

    public KmlUnaryOp() {
    }

    public KmlExpression getOperand() {
        return this.operand;
    }

    public KmlUnaryOp(KmlExpression operand) {
        this.operand = operand;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    public String getOpname() {
        return this.opname;
    }

    @Override
    public String getRawValue() {
        return String.valueOf(this.prefix ? String.valueOf(this.opname) + " " : "") + this.operand.toString() + (this.prefix ? "" : " " + this.opname);
    }

    @Override
    public boolean resolveType(KmlContext context) {
        this.operand.resolveType(context);
        if (this.operand.getType() == null) {
            context.getLogger().log(" : null type for " + this.operand, this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
            return false;
        }
        ArrayList<CostoType> operandsTypes = new ArrayList<CostoType>();
        operandsTypes.add(this.operand.getType());
        this.function = context.resolveFunction(this.opname, operandsTypes, this);
        if (this.function == null) {
            return false;
        }
        this.function.setOp(true);
        this.type = this.function.getType();
        return true;
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public ArrayList<KmlExpression> getOperands() {
        ArrayList<KmlExpression> list = new ArrayList<KmlExpression>();
        list.add(this.operand);
        return list;
    }

    @Override
    public void setFunction(KmlSignature function) {
        this.opname = function.getName();
        super.setFunction(function);
    }
}

