/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.expressions;

import costo.graph.KmlContext;
import costo.graph.expressions.ExpressionEvaluatorVisitor;
import costo.graph.expressions.ExpressionVisitor;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlIdentifier;
import costo.graph.types.CostoType;
import costo.graph.types.CostoUnknownType;
import costo.graph.types.StructuredType;

public class NavigateExpression
extends KmlIdentifier {
    private KmlExpression leftPart;
    private KmlExpression navig;

    public NavigateExpression(KmlExpression leftPart, KmlExpression index) {
        this.leftPart = leftPart;
        this.setLine(leftPart.getLine());
        this.setColumn(leftPart.getColumn());
        this.navig = index;
    }

    @Override
    public <T> T acceptEval(ExpressionEvaluatorVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public KmlExpression getLeftPart() {
        return this.leftPart;
    }

    public void setLeftPart(KmlExpression leftPart) {
        this.leftPart = leftPart;
    }

    public KmlExpression getIndex() {
        return this.navig;
    }

    public void setIndex(KmlExpression index) {
        this.navig = index;
    }

    @Override
    public String getRawValue() {
        return String.valueOf(this.leftPart.getRawValue()) + "[" + this.navig.getRawValue() + "]";
    }

    @Override
    public CostoType getType() {
        return CostoUnknownType.instance;
    }

    @Override
    public boolean resolveType(KmlContext context) {
        boolean istyped = this.leftPart.resolveType(context);
        if (istyped && !(this.leftPart.getType() instanceof StructuredType)) {
            context.getLogger().log(" in " + this + " : " + this.leftPart + "is not a structuredType", this, "TYPE ERROR", this.getLine(), this.getColumn(), context.getFilePath());
            return false;
        }
        if (istyped) {
            this.setType(((StructuredType)this.leftPart.getType()).getField(this.navig.getRawValue()));
            if (this.type == null) {
                context.getLogger().log(" in " + this + " : " + this.navig + "is not a field of the structuredType " + this.leftPart.getType(), this, "TYPE ERROR", this.getLine(), this.navig.getColumn(), context.getFilePath());
            }
        }
        return false;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            this.leftPart.accept(visitor);
            this.navig.accept(visitor);
        }
    }

    @Override
    public KmlExpression deepCopy() {
        NavigateExpression twin = new NavigateExpression(this.leftPart.deepCopy(), this.navig.deepCopy());
        twin.setType(this.type);
        twin.setRawValue(this.getRawValue());
        twin.setLine(this.getLine());
        twin.setColumn(this.getColumn());
        return twin;
    }
}

