/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.types;

import costo.graph.KmlContext;
import costo.graph.expressions.KmlIdentifier;
import costo.graph.types.CostoInteger;
import costo.graph.types.CostoType;

public class CostoRange
extends CostoType {
    public static final CostoRange instance = new CostoRange("0", "0");
    protected int borneInf;
    protected int borneSup;
    private String borneInfName;
    private String borneSupName;
    private KmlIdentifier lowerBound;
    private KmlIdentifier upperBound;

    public CostoRange() {
    }

    public int getBorneInf() {
        return this.borneInf;
    }

    public void setBorneInf(String borneInf) {
        try {
            this.borneInf = Integer.parseInt(borneInf);
        }
        catch (NumberFormatException numberFormatException) {}
        this.borneInfName = borneInf;
    }

    public int getBorneSup() {
        return this.borneSup;
    }

    public void setBorneSup(String borneSup) {
        try {
            this.borneSup = Integer.parseInt(borneSup);
        }
        catch (NumberFormatException numberFormatException) {}
        this.borneSupName = borneSup;
    }

    public CostoRange(String borneInf, String borneSup) {
        this.setBorneInf(borneInf);
        this.setBorneSup(borneSup);
    }

    public boolean isInRange(String index) {
        try {
            return this.isInRange(Integer.parseInt(index));
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean resolve(KmlContext context) {
        if (this.lowerBound != null) {
            if (!this.lowerBound.resolveType(context)) {
                context.getLogger().log("Invalid Lower Bound in " + this.getRawdescription(), this, "TYPE ERROR", this.lowerBound.getLine(), this.lowerBound.getColumn(), context.getName());
            } else {
                try {
                    this.borneInf = Integer.parseInt(this.lowerBound.getVar().getValue());
                }
                catch (Exception e) {
                    context.getLogger().log(e.getMessage(), this, "ERROR", this.lowerBound.getLine(), this.lowerBound.getColumn(), context.getName());
                }
            }
        }
        if (this.upperBound != null) {
            if (!this.upperBound.resolveType(context)) {
                context.getLogger().log("Invalid Upper Bound in " + this.getRawdescription(), this, "TYPE ERROR", this.upperBound.getLine(), this.upperBound.getColumn(), context.getName());
            } else {
                try {
                    this.borneSup = Integer.parseInt(this.upperBound.getVar().getValue());
                }
                catch (Exception e) {
                    context.getLogger().log(e.getMessage(), this, "ERROR", this.upperBound.getLine(), this.upperBound.getColumn(), context.getName());
                }
            }
        }
        return true;
    }

    public boolean isInRange(int index) {
        if (index > this.borneSup) {
            return false;
        }
        return index >= this.borneInf;
    }

    @Override
    public String getRawdescription() {
        return "[" + this.borneInfName + ".." + this.borneSupName + "]";
    }

    public String getBorneInfName() {
        return this.borneInfName;
    }

    public void setBorneInfName(String borneInfName) {
        this.borneInfName = borneInfName;
    }

    public String getBorneSupName() {
        return this.borneSupName;
    }

    public void setBorneSupName(String borneSupName) {
        this.borneSupName = borneSupName;
    }

    public KmlIdentifier getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(KmlIdentifier upperBound) {
        this.upperBound = upperBound;
        this.borneSupName = upperBound.getRawValue();
    }

    public KmlIdentifier getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(KmlIdentifier lowerBound) {
        this.lowerBound = lowerBound;
        this.borneInfName = lowerBound.getRawValue();
    }

    @Override
    public boolean conformsTo(CostoType expected) {
        boolean ok = false;
        if (expected == CostoInteger.instance) {
            return true;
        }
        if (expected == instance) {
            return true;
        }
        try {
            CostoRange expectedRange = (CostoRange)expected;
            ok = this.borneInf >= expectedRange.borneInf && this.borneSup <= expectedRange.borneSup;
        }
        catch (ClassCastException classCastException) {
            ok = false;
        }
        if (!ok && expected != null) {
            ok = expected.isAssignableFrom(this);
        }
        return ok;
    }

    @Override
    public boolean isAssignableFrom(CostoType costoType) {
        CostoRange expectedRange;
        block4: {
            if (costoType == CostoInteger.instance) {
                return true;
            }
            try {
                expectedRange = (CostoRange)costoType;
                if (this != instance) break block4;
                return true;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        boolean ok = this.borneInf <= expectedRange.borneInf && this.borneSup >= expectedRange.borneSup;
        return ok;
    }
}

