/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.types;

import costo.graph.KmlContext;
import costo.graph.Variable;
import costo.graph.expressions.KmlExpression;
import costo.graph.expressions.KmlSignature;
import java.util.ArrayList;

public class CostoType {
    protected String name = "anonymous";
    protected String rawdescription = "";
    private ArrayList<KmlSignature> operations = null;
    protected boolean anonymous = true;
    private boolean primitive = false;
    protected static int number = 0;

    public void setPrimitive(boolean primitive) {
        this.primitive = primitive;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public CostoType(String name, String rawdescription) {
        this(name, rawdescription, false);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return ((CostoType)obj).getRawdescription().equalsIgnoreCase(this.getRawdescription());
    }

    public CostoType(String name, String rawdescription, boolean anonymous) {
        this.name = name;
        this.rawdescription = rawdescription;
        this.anonymous = anonymous;
        if (name.equals(rawdescription)) {
            this.primitive = true;
        }
    }

    public CostoType() {
        this.name = "anonymous" + number;
        ++number;
    }

    public CostoType(String name) {
        this(name, name, false);
    }

    public String getName() {
        if (this.anonymous) {
            return this.getRawdescription();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.rawdescription == null) {
            this.rawdescription = name;
        }
        if (name.equals(this.rawdescription)) {
            this.primitive = true;
        }
        this.anonymous = false;
    }

    public String getRawdescription() {
        return this.rawdescription;
    }

    public void setRawdescription(String rawdescription) {
        this.rawdescription = rawdescription;
        if (this.name.equals(rawdescription)) {
            this.primitive = true;
        }
    }

    public String toString() {
        if (this.anonymous || this.primitive) {
            return this.getRawdescription();
        }
        return String.valueOf(this.getName()) + " : " + this.getRawdescription();
    }

    public boolean conformsTo(CostoType expected) {
        boolean ok = this.equals(expected);
        if (!ok && expected != null) {
            ok = expected.isAssignableFrom(this);
        }
        return ok;
    }

    public boolean isAssignableFrom(CostoType costoType) {
        return this.equals(costoType);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public Variable createVariable(String name, boolean constant) {
        return new Variable(name, this, constant);
    }

    public static CostoType createType(String line) {
        CostoType temp = null;
        String[] split = line.split("@");
        try {
            temp = (CostoType)Class.forName(split[1].trim()).getField("instance").get(null);
            if (!temp.getName().equalsIgnoreCase(split[0].trim())) {
                System.err.println("Warning ! Type " + split[0] + " is implemented with " + temp.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return temp;
    }

    public static CostoType getNewCostoType(KmlExpression referenceclass) {
        CostoType type = null;
        try {
            type = (CostoType)Class.forName(referenceclass.getRawValue()).getField("instance").get(null);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return type;
    }

    public CostoType instanciatedWithType(CostoType lastType) {
        return this;
    }

    public boolean resolve(KmlContext context) {
        return true;
    }

    public ArrayList<KmlSignature> getOperations() {
        return this.operations;
    }

    public void setOperations(ArrayList<KmlSignature> operations) {
        this.operations = operations;
    }
}

