/*
 * Decompiled with CFR 0.152.
 */
package costo.graph.types;

import costo.graph.KmlContext;
import costo.graph.StructuredVariable;
import costo.graph.Variable;
import costo.graph.types.CostoType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StructuredType
extends CostoType {
    protected HashMap<String, CostoType> fields;

    public StructuredType() {
    }

    public StructuredType(HashMap<String, CostoType> fields) {
        this.fields = fields;
    }

    public StructuredType(String name, HashMap<String, CostoType> fields) {
        super(name);
        this.fields = fields;
    }

    public HashMap<String, CostoType> getFields() {
        return this.fields;
    }

    public CostoType getField(String fieldname) {
        if (this.fields == null) {
            return null;
        }
        return this.fields.get(fieldname);
    }

    public void setFields(HashMap<String, CostoType> fields) {
        this.fields = fields;
    }

    public void setVarAsFields(HashMap<String, Variable> varfields) {
        this.fields = new HashMap();
        for (Variable field : varfields.values()) {
            this.fields.put(field.getName(), field.getCtype());
        }
    }

    public void setVarAsFields(ArrayList<Variable> varfields) {
        this.fields = new HashMap();
        for (Variable field : varfields) {
            this.fields.put(field.getName(), field.getCtype());
        }
    }

    @Override
    public String getRawdescription() {
        String raw = "struct {";
        ArrayList<String> ugly = new ArrayList<String>();
        ugly.addAll(this.fields.keySet());
        Collections.sort(ugly);
        Iterator it = ugly.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            raw = String.valueOf(raw) + key + ":" + this.fields.get(key).getName();
            if (!it.hasNext()) continue;
            raw = String.valueOf(raw) + ";";
        }
        return String.valueOf(raw) + "}";
    }

    @Override
    public Variable createVariable(String name, boolean constant) {
        HashMap<String, Variable> fieldsVars = new HashMap<String, Variable>();
        for (Map.Entry<String, CostoType> entry : this.fields.entrySet()) {
            fieldsVars.put(entry.getKey(), entry.getValue().createVariable(entry.getKey(), false));
        }
        return new StructuredVariable(name, this, constant, fieldsVars);
    }

    @Override
    public CostoType instanciatedWithType(CostoType lastType) {
        HashMap<String, CostoType> newmap = new HashMap<String, CostoType>();
        for (Map.Entry<String, CostoType> entry : this.fields.entrySet()) {
            newmap.put(entry.getKey(), entry.getValue().instanciatedWithType(lastType));
        }
        return new StructuredType(this.name, newmap);
    }

    @Override
    public boolean resolve(KmlContext context) {
        boolean ok = true;
        for (CostoType ct : this.fields.values()) {
            ok &= ct.resolve(context);
        }
        return ok;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StructuredType) {
            StructuredType other = (StructuredType)obj;
            return this.name.equals(other.getName()) && this.fields.equals(other.getFields());
        }
        return super.equals(obj);
    }
}

