/*
 * Decompiled with CFR 0.152.
 */
package costo.utils.exports;

import costo.Loader;
import costo.graph.Component;
import costo.graph.ComponentVariable;
import costo.graph.Composition;
import costo.graph.LTS;
import costo.graph.Service;
import costo.utils.exports.EPSUtils;
import costo.utils.exports.LTStoEPS;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public class KMLtoTEX {
    protected static boolean verbose = true;
    protected static boolean errverbose = true;
    static String latexFooter = "\\section{Conclusion}\n\\listoffigures\n%\\listoftables\n\\lstlistoflistings\n%\\printindex\n\\end{document}\n";

    public static String SetLatexHeader(String latexstyledir, String author, String title) {
        String header = "\\NeedsTeXFormat{LaTeX2e}\n%generated by the KMLtoTEX export utilities\n%author : COLOSS\n%date : " + new Date() + "\n" + "%\\batchmode" + "\n" + "\\documentclass[a4paper,11pt]{article}" + "\n" + "\\usepackage[dvips]{epsfig}" + "\n" + "\\usepackage[T1]{fontenc}" + "\n" + "\\usepackage{ae}" + "\n" + "\\usepackage{xspace}" + "\n" + "%-------- LaTeX style for Kmelia specifications " + "\n" + "\\usepackage[savemem]{listings}" + "\n" + "%-------- TODO Set a Kml listing configuration" + "\n";
        header = latexstyledir.equals("") ? String.valueOf(header) + "\\def\\repLATEX{../../../../LATEX} %TO UPDATE LATEX STYLES DIRECTORY\n" : String.valueOf(header) + "\\def\\repLATEX{" + latexstyledir + "}" + "\n";
        header = String.valueOf(header) + "%-------- Files to put in the repLATEX directory \n\\usepackage{\\repLATEX/zedbis}    % LaTeX/Z utilities\n\\usepackage{\\repLATEX/declar}    % various shortcuts\n\\usepackage{\\repLATEX/a4pasc}    % full page \n\\usepackage{\\repLATEX/listfoot}\n\\def\\repBIBLIO{.}                %TO UPDATE BIBLIOGRAPHY REFERENCE DIRECTORY\n\\def\\repFIGURES{./FIGURES}       % DOT/EPS FIGURE DIRECTORY\n\\usepackage{multicol}\n\\usepackage{url}\n%-------- Local Definitions \n\\newcounter{references}           % for the figures\n\\newcounter{reftab}               % for the tables\n\\def\\kmelia{\\textsf{Kmelia}\\xspace}\n\\def\\Lotos{\\textsc{Lotos}\\xspace}\n\n%-------- Title Definitions \n";
        header = title.equals("") ? String.valueOf(header) + "\\title{\\kmelia Specifications}\n" : String.valueOf(header) + "\\title{" + title + "}" + "\n";
        header = author.equals("") ? String.valueOf(header) + "\\author{Coloss}\n" : String.valueOf(header) + "\\author{" + author + "}" + "\n";
        header = String.valueOf(header) + "\\date{\\today}\n\\begin{document}\n";
        header = String.valueOf(header) + "\\maketitle\n";
        header = String.valueOf(header) + "\\begin{abstract}\n";
        header = String.valueOf(header) + "This document has been produced automatically by the COSTO/\\kmelia Tex Export tool.\\\\\n";
        header = String.valueOf(header) + "~\\\\ Please insert here your abstract comment ~\\\\ \n";
        header = String.valueOf(header) + "~\\\\ \\noindent \\textbf{Keywords}:~Components, Services, LTS, \\kmelia ~\\\\\n";
        header = String.valueOf(header) + "\\end{abstract}\n";
        header = String.valueOf(header) + "\\newpage\n\\tableofcontents\n\\newpage\n";
        header = String.valueOf(header) + "\\section{Introduction}\n";
        return header;
    }

    private static String LatexFilter(String s) {
        return s.replace("_", "\\_");
    }

    public static String LatexFig(String epsfilename, String legende) {
        return "\\begin{center}\n%\\begin{figure}[h]\n\\centerline{\\epsfig{figure=\\repFIGURES/" + epsfilename + ",width=12cm}}          % TO UPDATE" + "\n" + "\\legende{" + epsfilename + "}{" + KMLtoTEX.LatexFilter(legende) + "}" + "\n" + "%\\end{figure}" + "\n" + "\\end{center}" + "\n";
    }

    public static String LatexFig(String outputpath, String epsfilename, String legende) {
        Point size = EPSUtils.getBoundingBox(String.valueOf(outputpath) + "FIGURES" + "/" + epsfilename);
        if (size.getX() == 0.0 && size.getY() == 0.0) {
            size.x = 1080;
            System.err.print(String.valueOf(epsfilename) + " taille " + size.toString() + "-");
        }
        return "\\begin{center}\n%\\begin{figure}[h]\n\\centerline{\\epsfig{figure=\\repFIGURES/" + epsfilename + ",width=" + size.getX() / 90.0 + "cm}}          % TO UPDATE" + "\n" + "\\legende{" + epsfilename + "}{" + KMLtoTEX.LatexFilter(legende) + "}" + "\n" + "%\\end{figure}" + "\n" + "\\end{center}" + "\n";
    }

    private static String LatexListing(LTS lts) {
        String label = String.valueOf(lts.getComponentName()) + "." + lts.getServiceName();
        return "\\footnotesize\n\\begin{lstlisting}[caption={" + KMLtoTEX.LatexFilter("Behaviour of " + label) + "},label=,frame=lines]\n" + lts.toString() + "\n\\end{lstlisting}\n" + "\\normalsize" + "\n";
    }

    private static String LatexListing(Service serv) {
        String label = String.valueOf(serv.getOwner().getName()) + "." + serv.getName();
        String tex = "\\paragraph{Comments}\n";
        tex = String.valueOf(tex) + KMLtoTEX.LatexFilter(serv.getComment()) + ".\n";
        tex = String.valueOf(tex) + "\\footnotesize\n\\begin{lstlisting}[caption={" + KMLtoTEX.LatexFilter("Service " + label) + "},label=,frame=lines]\n" + serv.toString() + "\n\\end{lstlisting}\n" + "\\normalsize" + "\n";
        return tex;
    }

    private static String LatexListing(Component comp) {
        String label = comp.getName();
        String tex = "";
        tex = String.valueOf(tex) + "\\paragraph{Comments}\n";
        tex = String.valueOf(tex) + KMLtoTEX.LatexFilter(comp.getComment()) + ".\n";
        tex = String.valueOf(tex) + "\\footnotesize\n\\begin{lstlisting}[caption={" + KMLtoTEX.LatexFilter("Component " + label) + "},label=,frame=lines]\n" + comp.toString(true, true, true, true, true, true, true, true, false, true) + "\n\\end{lstlisting}\n" + "\\normalsize" + "\n";
        return tex;
    }

    private static String LatexListing(Composition compos) {
        String label = compos.getOwner().getName();
        String tex = "";
        tex = String.valueOf(tex) + "\\paragraph{Diagram}\n\\begin{center}\n%\\begin{figure}[h]\n\\centerline{\\epsfig{figure=\\repFIGURES/" + label + ".eps, width=12 cm}}" + "\n" + "\\legende{" + label + ".dia}{" + KMLtoTEX.LatexFilter(label) + "}" + "\n" + "%\\end{figure}" + "\n" + "\\end{center}" + "\n";
        tex = String.valueOf(tex) + "\\paragraph{Comments}\n";
        tex = String.valueOf(tex) + KMLtoTEX.LatexFilter(compos.getComment()) + ".\n";
        tex = String.valueOf(tex) + "\\footnotesize\n\\begin{lstlisting}[caption={" + KMLtoTEX.LatexFilter("Composition of " + label) + "},label=,frame=lines]\n" + compos.toString() + "\n\\end{lstlisting}\n" + "\\normalsize" + "\n";
        return tex;
    }

    public static FileWriter OpenTexFile(String outputpath, String filename, String author, Properties prop) throws IOException {
        if (outputpath == null) {
            outputpath = System.getProperty("user.dir");
            if (verbose) {
                System.out.println("Output to " + outputpath);
            }
        }
        String figoutputdir = String.valueOf(outputpath) + "FIGURES" + "/";
        String title = "System " + KMLtoTEX.LatexFilter(filename);
        title = String.valueOf(title) + "~\\\\ \n {\\small " + prop.getProperty("costo.tex.title") + "}";
        new File(figoutputdir).mkdirs();
        FileWriter fw = new FileWriter(String.valueOf(outputpath) + filename + ".tex");
        fw.write(KMLtoTEX.SetLatexHeader("", author, title));
        return fw;
    }

    public static void CloseTexFile(FileWriter fw) throws IOException {
        fw.write(latexFooter);
        fw.close();
    }

    public static void LTStoTex(LTS lts, String outputpath) throws IOException {
        KMLtoTEX.LTStoTex(lts, outputpath, "coloss", null);
    }

    public static void LTStoTex(LTS lts, String outputpath, String author, Properties p) throws IOException {
        if (lts == null) {
            return;
        }
        String filename = lts.getOwner() == null || lts.getComponentName() == null ? "NoLTSContext" : String.valueOf(lts.getComponentName()) + "." + lts.getServiceName();
        FileWriter fw = KMLtoTEX.OpenTexFile(outputpath, filename, author, p);
        fw.write(KMLtoTEX.LatexFilter("This document includes an automatic specification of the behaviour of Service " + lts.getServiceName() + " of the component " + lts.getComponentName() + ".\n"));
        fw.write(KMLtoTEX.LatexFilter("\\section{Behaviour of Service " + lts.getServiceName() + " of the component " + lts.getComponentName() + "}\n"));
        fw.write(KMLtoTEX.LatexListing(lts));
        LTStoEPS.write(lts, String.valueOf(outputpath) + "FIGURES" + "/", filename, p);
        fw.write(KMLtoTEX.LatexFig(outputpath, String.valueOf(filename) + ".dot_layout.eps", filename));
        fw.flush();
        KMLtoTEX.CloseTexFile(fw);
    }

    public static void serviceToTex(Service serv, String outputpath) throws IOException {
        KMLtoTEX.serviceToTex(serv, outputpath, "coloss", null);
    }

    public static void serviceToTex(Service serv, String outputpath, String author, Properties prop) throws IOException {
        if (serv == null) {
            return;
        }
        String filename = serv.getOwner() == null ? "NoServiceContext" : String.valueOf(serv.getOwner().getName()) + "." + serv.getName();
        FileWriter fw = KMLtoTEX.OpenTexFile(outputpath, filename, author, prop);
        fw.write(KMLtoTEX.LatexFilter("This document includes an automatic specification of the behaviour of the service " + serv.getName() + " of the component " + serv.getOwner().getName() + ".\n"));
        fw.write(KMLtoTEX.LatexFilter("\\section{Service " + serv.getName() + " of the component " + serv.getOwner().getName() + "}\n"));
        fw.write(KMLtoTEX.LatexListing(serv));
        LTStoEPS.write(serv.getBehavior(), String.valueOf(outputpath) + "FIGURES" + "/", filename, prop);
        fw.write(KMLtoTEX.LatexFig(outputpath, String.valueOf(filename) + ".dot_layout.eps", filename));
        KMLtoTEX.CloseTexFile(fw);
    }

    public static void componentToTex(Component comp, String outputpath) throws IOException {
        KMLtoTEX.componentToTex(comp, outputpath, "coloss", null);
    }

    protected static void writeBaseComponentToTex(FileWriter fw, String filename, Component comp, String outputpath, Properties prop) throws IOException {
        fw.write(KMLtoTEX.LatexFilter("\\section{Component " + comp.getName() + "}\n"));
        fw.write(KMLtoTEX.LatexListing(comp));
        for (Service serv : comp.getServices()) {
            fw.write(KMLtoTEX.LatexFilter("\\subsection{Service " + serv.getName() + "}\n"));
            fw.write(KMLtoTEX.LatexListing(serv));
            if (serv.getBehavior() == null) continue;
            String servfilename = String.valueOf(comp.getName()) + "." + serv.getName();
            LTStoEPS.write(serv.getBehavior(), String.valueOf(outputpath) + "FIGURES" + "/", servfilename, prop);
            fw.write(KMLtoTEX.LatexFig(outputpath, String.valueOf(servfilename) + ".dot_layout.eps", servfilename));
        }
    }

    protected static void writeComponentToTex(FileWriter fw, String filename, Component comp, String outputpath, Properties prop) throws IOException {
        if (comp.isComposite()) {
            fw.write(KMLtoTEX.LatexFilter("\\section{Component " + comp.getName() + "}\n"));
            fw.write(KMLtoTEX.LatexListing(comp));
            for (Service serv : comp.getServices()) {
                if (!serv.isPromoted()) {
                    fw.write(KMLtoTEX.LatexFilter("\\subsection{Service " + serv.getName() + "}\n"));
                    fw.write(KMLtoTEX.LatexListing(serv));
                    if (serv.getBehavior() == null) continue;
                    String servfilename = String.valueOf(comp.getName()) + "." + serv.getName();
                    LTStoEPS.write(serv.getBehavior(), String.valueOf(outputpath) + "FIGURES" + "/", servfilename, prop);
                    fw.write(KMLtoTEX.LatexFig(outputpath, String.valueOf(servfilename) + ".dot_layout.eps", servfilename));
                    continue;
                }
                if (!verbose) continue;
                System.out.println("promoted service: " + serv.getName());
            }
            Composition compos = comp.getComposition();
            fw.write(KMLtoTEX.LatexFilter("\\subsection{Composition part of " + comp.getName() + "}\n"));
            fw.write(KMLtoTEX.LatexListing(compos));
            for (ComponentVariable part : compos.getAssembly().getNamedComponents()) {
                KMLtoTEX.writeComponentToTex(fw, filename, part.getComponentType(), outputpath, prop);
            }
        } else {
            KMLtoTEX.writeBaseComponentToTex(fw, filename, comp, outputpath, prop);
        }
    }

    public static void componentToTex(Component comp, String outputpath, String author, Properties prop) throws IOException {
        if (comp == null) {
            return;
        }
        String filename = comp.getName();
        FileWriter fw = KMLtoTEX.OpenTexFile(outputpath, filename, author, prop);
        fw.write(KMLtoTEX.LatexFilter("This document includes an automatic specification of the component " + filename + ".\n"));
        KMLtoTEX.writeComponentToTex(fw, filename, comp, outputpath, prop);
        KMLtoTEX.CloseTexFile(fw);
    }

    public static void main(String[] args) throws Exception {
        Properties userprop = new Properties();
        userprop.load(new FileInputStream("Costolib.userprefs"));
        String archi = userprop.getProperty("costo.archi");
        String basedir = archi.equals("windows") ? userprop.getProperty("costo.Winbasedir") : (archi.equals("linux") ? userprop.getProperty("costo.Linbasedir") : userprop.getProperty("costo.basedir"));
        if (errverbose) {
            System.err.println("basedir : " + basedir);
        }
        String specdir = String.valueOf(basedir) + userprop.getProperty("costo.specdir");
        if (errverbose) {
            System.err.println("specdir : " + specdir);
        }
        String component_name = userprop.getProperty("costo.basecomp");
        Component comp = Loader.loadComponent(specdir, component_name);
        String main_serv = userprop.getProperty("costo.mainserv");
        if (errverbose) {
            System.err.println("main_serv : " + main_serv);
        }
        String outputdir = String.valueOf(specdir) + "LATEX" + "/";
        if (errverbose) {
            System.err.println("outputdir : " + outputdir);
        }
        comp.getService(main_serv);
        KMLtoTEX.componentToTex(comp, outputdir, "COLOSS ", userprop);
        System.out.println("level : comp " + comp.getName());
        System.out.println("##########################################");
    }

    @Deprecated
    protected static class LatexContext {
        boolean valid = false;
        Level grain;
        Component composite;
        Component component;
        Service service;
        String specdir;
        String outputdir;
        String figoutputdir;

        public String getOutputdir() {
            return this.outputdir;
        }

        public static enum Level {
            composite,
            component,
            service;

        }
    }
}

