/*
 * Decompiled with CFR 0.152.
 */
package costo.utils.exports;

import costo.graph.Component;
import costo.graph.ComponentFactory;
import costo.graph.LTS;
import costo.graph.State;
import costo.graph.Transition;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;

public class LTStoDot {
    static String graphstyle = "fontsize = \"14\" \nfontname = \"Times-Roman\"\nfontcolor = \"black\"\nbb = \"0,0,648,180\"\ncolor = \"black\"\n";
    static String nodestyle = "fontsize = \"14\" \nfontname = \"Times-Roman\"\nfontcolor = \"black\"\nshape = \"ellipse\"\ncolor = \"black\"\n";
    static String edgestyle = "fontsize = \"14\" \nfontname = \"Times-Roman\"\nfontcolor = \"black\"\ncolor = \"black\"\ndir = \"forward\"\n";

    public static String StringifyQuotes(String s) {
        return s.replace("\"", "\\\"");
    }

    public static void write(LTS lts) throws IOException {
        LTStoDot.write(lts, String.valueOf(lts.getComponentName()) + "." + lts.getServiceName() + ".dot");
    }

    public static void write(LTS lts, String fileOut) throws IOException {
        FileWriter fw = new FileWriter(fileOut);
        fw.write(LTStoDot.LTSDotstring(lts));
        fw.close();
    }

    private static String LTSDotstring(LTS lts) {
        String header = "digraph \"" + lts.getOwner().getFullName() + "\" {\n";
        header = String.valueOf(header) + " graph [\n" + graphstyle + "]\n";
        header = String.valueOf(header) + " node [\n" + nodestyle + "]\n";
        header = String.valueOf(header) + " edge [\n" + edgestyle + "]\n";
        String nodeslist = "";
        Iterator<State> iter = lts.iteratorOnStates();
        while (iter.hasNext()) {
            nodeslist = String.valueOf(nodeslist) + LTStoDot.NodeDotString(iter.next());
        }
        String translist = "";
        for (Transition element : lts.getTransitions()) {
            translist = String.valueOf(translist) + LTStoDot.TransitionDotString(element);
        }
        return String.valueOf(header) + nodeslist + translist + "}\n";
    }

    private static String TransitionDotString(Transition t) {
        String res = " \"" + t.getSource().getName() + "\" -> \"" + t.getTarget().getName() + "\" [\n" + "label = \"";
        if (t.getLabel().isGuarded().booleanValue()) {
            res = String.valueOf(res) + LTStoDot.StringifyQuotes("[" + t.getLabel().getGuard().toString() + "]\\n ");
        }
        String exps = t.getLabel().getExpression().toString();
        String[] ea = exps.split(";");
        res = String.valueOf(res) + LTStoDot.StringifyQuotes(ea[0]);
        int x = 1;
        while (x < ea.length) {
            res = String.valueOf(res) + LTStoDot.StringifyQuotes(";\\n " + ea[x]);
            ++x;
        }
        res = String.valueOf(res) + "\", kmltag=\"" + t.getLabel().getStringActionType() + "\"\n" + "]\n";
        return res;
    }

    private static String NodeDotString(State s) {
        return "\"" + s.getName() + "\" [\n" + "label = \"" + LTStoDot.StringifyQuotes(s.toLongString()) + "\"\n" + "]\n";
    }

    public static void main(String[] args) throws Exception {
        ComponentFactory basefactory = new ComponentFactory();
        basefactory.init();
        String dirname = String.valueOf(System.getProperty("user.dir")) + "/spec/chat/";
        System.out.println(dirname);
        String compname = "ChatServer.cmp";
        String servicename = "chat";
        if (args.length == 3) {
            dirname = args[0];
            compname = args[1];
            servicename = args[2];
        }
        Component test = basefactory.getComponent(String.valueOf(System.getProperty("user.dir")) + "/spec/chat/" + compname);
        LTStoDot.write(test.getService(servicename).getBehavior(), String.valueOf(servicename) + ".dot");
        String s = "test \" test ";
        System.out.println(s);
        System.out.println(LTStoDot.StringifyQuotes(s));
        test = basefactory.getComponent("ChatClient");
    }
}

